% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/valid.R
\name{is_valid.default}
\alias{is_valid.default}
\alias{is_valid_major}
\alias{is_valid_major.default}
\alias{is_valid_major.icd9}
\alias{is_valid_major.icd10}
\alias{icd9_is_valid_major_n}
\alias{icd9_is_valid_major_v}
\alias{icd9_is_valid_major_e}
\title{Test whether an ICD code is major}
\usage{
\method{is_valid}{default}(x, short_code = guess_short(x), ...)

is_valid_major(x, whitespace_ok = TRUE)

\method{is_valid_major}{default}(x, whitespace_ok = TRUE)

\method{is_valid_major}{icd9}(x, whitespace_ok = TRUE)

\method{is_valid_major}{icd10}(x, whitespace_ok = TRUE)

icd9_is_valid_major_n(x, whitespace_ok = TRUE)

icd9_is_valid_major_v(x, whitespace_ok = TRUE)

icd9_is_valid_major_e(x, whitespace_ok = TRUE)
}
\arguments{
\item{x}{vector of ICD codes}
}
\value{
logical vector of same length as input, with \code{TRUE} when a code
  is a major (not necessarily a real one)
}
\description{
Codes without real or implied decimal place return \code{TRUE}
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Test whether an ICD code is of major type,
which at present assumes ICD-9 format. Converts to character than calls
\code{is_valid.character}

\item \code{default}: Test whether an ICD code is of major type,
either ICD-9 or ICD-10

\item \code{icd9}: Test whether an ICD-9 code is of major type.

\item \code{icd10}: Test whether an ICD-9 code is of major type.
}}

\keyword{internal}
