% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/factor_nosort.R
\name{factor_nosort}
\alias{factor_nosort}
\title{Fast Factor Generation}
\usage{
factor_nosort(x, levels, labels = levels, exclude = NA)
}
\arguments{
\item{x}{An object of atomic type \code{integer}, \code{numeric},
\code{character} or \code{logical}.}

\item{levels}{An optional character vector of levels. Is coerced to the same
type as \code{x}. By default, we compute the levels as
\code{sort(unique.default(x))}.}

\item{labels}{A set of labels used to rename the levels, if desired.}
}
\description{
This function generates factors more quickly, without leveraging
\code{fastmatch}. The speed increase with \code{fastmatch} for ICD-9 codes
was about 33% reduction for 10 million codes. SOMEDAY could be faster still
using \code{Rcpp}, and a hashed matching algorithm.
}
\details{
\code{NaN}s are converted to \code{NA} when used on numeric values. Extracted
from https://github.com/kevinushey/Kmisc.git

These feature from base R are missing: \code{exclude = NA, ordered =
is.ordered(x), nmax = NA}

I don't think there is any requirement for factor levels to be
  sorted in advance, especially not for ICD-9 codes where a simple
  alphanumeric sorting will likely be completely wrong.
}
\examples{
x <- c("z", "a", "123")
icd:::factor_nosort(x)
# should return a factor without modification
x <- as.factor(x)
identical(icd:::factor_nosort(x), x)
# unless the levels change:
icd:::factor_nosort(x, levels = c("a", "z"))

# existing factor levels aren't re-ordered without also moving elements
f <- factor(c("a", "b", "b", "c"))
g <- icd:::factor_nosort(f, levels = c("a", "c", "b"))
stopifnot(g[4] == "c")
}
\author{
Kevin Ushey, adapted by Jack Wasey
}
\keyword{internal}
