% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util-file.R
\name{unzip_to_data_raw}
\alias{download_to_data_raw}
\alias{unzip_to_data_raw}
\title{Unzip file to \code{data-raw}}
\usage{
unzip_to_data_raw(url, file_name, offline = TRUE, verbose = FALSE)

download_to_data_raw(url, file_name = str_extract(url, "[^/]*$"),
  offline = TRUE)
}
\arguments{
\item{url}{URL of a zip file}

\item{file_name}{file name of a single file in that zip}

\item{offline}{single logical, if \code{TRUE} then don't pull the file from
internet, only return path and file name if the file already exists in
data-raw. This is helpful for testing without using the internet.}

\item{force}{logical, if TRUE, then download even if already in
\code{data-raw}
@template verbose}
}
\value{
path of unzipped file in \code{data-raw}
}
\description{
Get a zip file from a URL, extract contents, and save file in
\code{data-raw}. If the file already exists there, it is only retrieved if
\code{force} is set to \code{TRUE}. If \code{offline} is \code{FALSE}, then
\code{NULL} is returned if the file isn't already downloaded.
}
\details{
The file name is changed to a conservative cross platform name using
\code{make.names}
}
\keyword{file}
\keyword{internal}

