% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{interval}
\alias{interval}
\title{Computes the confidence interval for the ICC}
\usage{
interval(x, conf = 0.95, method = c("EB", "AN", "ZT"))
}
\arguments{
\item{x}{An object of class \code{"iccTraj"}}

\item{conf}{Numeric. Level of confidence. Default is set to 0.95.}

\item{method}{String. Method used to estimate the confidence interval. Accepted values are **EB** for Empirical Bootstrap, **AN** for asymptotic Normal, and **ZT** for asymptotic Normal using the Z-transformation.}
}
\value{
A vector with the two boundaries of the confidence interval.
}
\description{
Computes the confidence interval for the ICC
}
\details{
Let \eqn{\hat{\theta}} denote the ICC sample estimate and \eqn{\theta_i^{B}} denote the ICC bootstrap estimates with \eqn{i=1,\ldots,B}. Let \eqn{\delta_{\alpha/2}^{B}} and \eqn{\delta_{1-\alpha/2}^{B}} be the \eqn{\frac{\alpha}{2}} and \eqn{1-\frac{\alpha}{2}} percentiles of \eqn{\delta_{i}^{B}=\theta_i^{B}-\hat{\theta}}. The empirical bootstrap confidence interval is then estimated as \eqn{\hat{\theta}+\delta_{\alpha/2}^{B},\hat{\theta}+\delta_{1-\alpha/2}^{B}}.

Asymptotic Normal (AN) interval is obtained as \eqn{\hat{\theta} \pm Z_{1-\alpha/2}*SE_B} where \eqn{SE_B} denotes the standard deviation of \eqn{\theta_i^{B}}, and \eqn{Z_{1-\alpha/2}} stands for the \eqn{1-\alpha/2} quantile of the standard Normal distribution.

In the ZT approach, the ICC is transformed using Fisher's Z-transformation. Then,  the AN approach is applied to the transformed ICC.
}
\examples{
\donttest{
# Using median Hausdorff distance
Hd<-iccTraj(gull_data,"ID","trip","LONG","LAT","triptime", parallel=FALSE, distance="H")
Hd$est
interval(Hd)
}
}
