% Generated by roxygen2 (4.0.2): do not edit by hand
\name{DST}
\alias{DST}
\title{Combination rules}
\usage{
DST(MassIn, criterion)
}
\arguments{
\item{MassIn}{The matrix containing the masses. Each column represents a
piece of mass.}

\item{criterion}{The combination criterion:

criterion=1 Smets criterion

criterion=2 Dempster-Shafer criterion (normalized)

criterion=3 Yager criterion

criterion=4 Disjunctive combination criterion

criterion=5 Dubois criterion (normalized and disjunctive combination)

criterion=6 Dubois and Prade criterion (mixt combination)

criterion=7 Florea criterion

criterion=8 PCR6

criterion=9 Cautious Denoeux Min for functions non-dogmatics

criterion=10 Cautious Denoeux Max for separable functions

criterion=11 Hard Denoeux for functions non-normales

criterion=12 Mean of the bbas}
}
\value{
The combined mass vector. One column.
}
\description{
Different rules to combine masses
}
\examples{
m1=c(0,0.4, 0.1, 0.2, 0.2, 0, 0, 0.1);
m2=c(0,0.2, 0.3, 0.1, 0.1, 0, 0.2, 0.1);
m3=c(0.1,0.2, 0, 0.1, 0.1, 0.1, 0, 0.3);

m3d=discounting(m3,0.95);

M_comb_Smets=DST(cbind(m1,m2,m3d),1);
M_comb_Smets
M_comb_PCR6=DST(cbind(m1,m2),8);
M_comb_PCR6
}

