% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_download_whoi_plankton.R
\name{ifcb_download_whoi_plankton}
\alias{ifcb_download_whoi_plankton}
\title{Download and Extract WHOI-Plankton Data}
\usage{
ifcb_download_whoi_plankton(
  years,
  dest_folder,
  extract_images = TRUE,
  max_retries = 10,
  quiet = FALSE
)
}
\arguments{
\item{years}{A vector of years (numeric or character) indicating which datasets to download. The available years are currently 2006 to 2014.}

\item{dest_folder}{A string specifying the destination folder where the files will be extracted.}

\item{extract_images}{Logical. If \code{TRUE}, extracts \code{.png} images from the downloaded archives and removes the \code{.zip} files.
If \code{FALSE}, only downloads the archives without extracting images. Default is \code{TRUE}.}

\item{max_retries}{An integer specifying the maximum number of attempts to retrieve data. Default is 10.}

\item{quiet}{Logical. If TRUE, suppresses messages about the progress and completion of the download process. Default is FALSE.}
}
\value{
If \code{extract_images = FALSE}, returns a data frame containing metadata of downloaded image files.
Otherwise, no return value; files are downloaded and extracted to \code{dest_folder}.
}
\description{
This function downloads WHOI-Plankton annotated plankton images (Sosik et al. 2015) for specified years
from \url{https://hdl.handle.net/1912/7341}.
The extracted \code{.png} data are saved in the specified destination folder.
}
\examples{
\dontrun{
# Download and extract images for 2006 and 2007 in the data folder
ifcb_download_whoi_plankton(c(2006, 2007),
                            "data",
                            extract_images = TRUE)
}

}
\references{
Sosik, H. M., Peacock, E. E. and Brownlee E. F. (2015), Annotated Plankton Images - Data Set for Developing and Evaluating Classification Methods. \doi{10.1575/1912/7341}
}
