% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_classify_images.R
\name{ifcb_classify_images}
\alias{ifcb_classify_images}
\title{Classify Pre-Extracted IFCB PNG Images Using a Gradio Application}
\usage{
ifcb_classify_images(
  png_file,
  gradio_url = "https://irfcb-classify.hf.space",
  top_n = 1,
  model_name = "SMHI NIVA ResNet50 V5",
  verbose = TRUE
)
}
\arguments{
\item{png_file}{A character vector of paths to PNG files to classify.}

\item{gradio_url}{A character string specifying the base URL of the Gradio
application. Default is \code{"https://irfcb-classify.hf.space"}, which is an
example Hugging Face Space with limited resources intended for testing and
demonstration. For large-scale classification, deploy your own instance of
the classification app (source code:
\url{https://github.com/EuropeanIFCBGroup/ifcb-inference-app}) and
pass its URL here.}

\item{top_n}{An integer specifying the number of top predictions to return
per image. Default is \code{1} (top prediction only). Use \code{Inf} to return all
predictions.}

\item{model_name}{A character string specifying the name of the CNN model
to use for classification. Default is \code{"SMHI NIVA ResNet50 V5"}. Use
\code{\link[=ifcb_classify_models]{ifcb_classify_models()}} to list all available models.}

\item{verbose}{A logical value indicating whether to print progress messages.
Default is \code{TRUE}.}
}
\value{
A data frame with the following columns:
\describe{
\item{\code{file_name}}{The PNG file name of the classified image.}
\item{\code{class_name}}{The predicted class name with per-class thresholds
applied; \code{"unclassified"} if the score is below the threshold.}
\item{\code{class_name_auto}}{The winning class name without any threshold
applied (argmax of scores).}
\item{\code{score}}{The prediction confidence score (0–1).}
\item{\code{model_name}}{The name of the CNN model used for classification.}
}
Images that could not be classified have \code{NA} in \code{class_name},
\code{class_name_auto}, and \code{score}.
When \code{top_n > 1}, multiple rows are returned per image (one per prediction).
}
\description{
Classifies one or more pre-extracted IFCB PNG images through a CNN model
served by a Gradio application. Each PNG is uploaded to the Gradio server
and the prediction result is returned as a data frame. Per-class F2 optimal
thresholds are applied automatically; predictions scoring below the
threshold for their class are labeled \code{"unclassified"} in \code{class_name}.
}
\details{
To classify all images in a raw IFCB sample (\code{.roi} file) without first
extracting them manually, use \code{\link[=ifcb_classify_sample]{ifcb_classify_sample()}} instead.
}
\examples{
\dontrun{
# Classify a single pre-extracted PNG
result <- ifcb_classify_images("path/to/D20220522T003051_IFCB134_00001.png")

# Classify several PNGs at once
pngs <- list.files("path/to/png_folder", pattern = "\\\\.png$",
                   full.names = TRUE)
result <- ifcb_classify_images(pngs, top_n = 3)
}

}
\seealso{
\code{\link[=ifcb_classify_sample]{ifcb_classify_sample()}} to classify all images in a raw IFCB
sample without prior extraction. \code{\link[=ifcb_classify_models]{ifcb_classify_models()}} to list
available CNN models. \code{\link[=ifcb_extract_pngs]{ifcb_extract_pngs()}} to extract PNG images from
IFCB ROI files.
}
