% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_psd.R
\name{ifcb_psd}
\alias{ifcb_psd}
\title{Plot and Save IFCB PSD Data}
\usage{
ifcb_psd(
  feature_folder,
  hdr_folder,
  save_data = FALSE,
  output_file = NULL,
  plot_folder = NULL,
  use_marker = FALSE,
  start_fit = 10,
  r_sqr = 0.5,
  beads = NULL,
  bubbles = NULL,
  incomplete = NULL,
  missing_cells = NULL,
  biomass = NULL,
  bloom = NULL,
  humidity = NULL,
  micron_factor = 1/3.4
)
}
\arguments{
\item{feature_folder}{The absolute path to a directory containing all of the v2 feature files for the dataset.}

\item{hdr_folder}{The absolute path to a directory containing all of the hdr files for the dataset.}

\item{save_data}{A boolean indicating whether to save data to CSV files. Default is FALSE.}

\item{output_file}{A string with the base file name for the .csv to use (including path). Set to NULL to not save data (default).}

\item{plot_folder}{The folder where graph images for each file will be saved. Set to NULL to not save graphs (default).}

\item{use_marker}{A boolean indicating whether to show markers on the plot. Default is FALSE.}

\item{start_fit}{An integer indicating the start fit value for the plot. Default is 10.}

\item{r_sqr}{The lower limit of acceptable R^2 values (any curves below it will be flagged). Default is 0.5.}

\item{beads}{The maximum multiplier for the curve fit. Any files with higher curve fit multipliers will be flagged as bead runs. If this argument is included, files with "runBeads" marked as TRUE in the header file will also be flagged as a bead run. Optional.}

\item{bubbles}{The minimum difference between the starting ESD and the ESD with the most targets.  Any files with a difference higher than this threshold will be flagged as mostly bubbles. Optional.}

\item{incomplete}{A tuple with the minimum volume of cells (in c/L) and the minimum mL analyzed for a complete run. Any files with values below these thresholds will be flagged as incomplete. Optional.}

\item{missing_cells}{The minimum image count to trigger count ratio. Any files with lower ratios will be flagged as missing cells. Optional.}

\item{biomass}{The minimum number of targets in the most populated ESD bin for any given run. Any files with fewer targets will be flagged as having low biomass. Optional.}

\item{bloom}{The minimum difference between the starting ESD and the ESD with the most targets. Any files with a difference less than this threshold will be flagged as a bloom. Will likely be lower than the bubbles threshold. Optional.}

\item{humidity}{The maximum percent humidity. Any files with higher values will be flagged as high humidity. Optional.}

\item{micron_factor}{The conversion factor to microns. Default is 1/3.4.}
}
\value{
A list with data, fits, and flags DataFrames if \code{save_data} is FALSE; otherwise, NULL.
}
\description{
This function generates and saves data about a dataset's Particle Size Distribution (PSD) from Imaging FlowCytobot (IFCB)
feature and hdr files, which can be used for data quality assurance and quality control.
}
\details{
The PSD function originates from the \code{PSD} python repository (Hayashi et al. in prep), which can be found at \url{https://github.com/kudelalab/PSD}.

Python must be installed to use this function. The required python packages can be installed in a virtual environment using \code{ifcb_py_install()}.

The function requires v2 features generated by the \code{ifcb-analysis} MATLAB package (Sosik and Olson 2007) found at \url{https://github.com/hsosik/ifcb-analysis}.
}
\examples{
\dontrun{
# Initialize the python session if not already set up
ifcb_py_install()

ifcb_psd(
  feature_folder = 'path/to/features',
  hdr_folder = 'path/to/hdr_data',
  save_data = TRUE,
  output_file = 'psd/svea_2021',
  plot_folder = 'psd/plots',
  use_marker = FALSE,
  start_fit = 13,
  r_sqr = 0.5,
  beads = 10 ** 9,
  bubbles = 150,
  incomplete = c(1500, 3),
  missing_cells = 0.7,
  biomass = 1000,
  bloom = 5,
  humidity = NULL,
  micron_factor = 1/3.0
)
}
}
\references{
Hayashi, K., Walton, J., Lie, A., Smith, J. and Kudela M. Using particle size distribution (PSD) to automate imaging flow cytobot (IFCB) data quality in coastal California, USA. In prep.
Sosik, H. M. and Olson, R. J. (2007), Automated taxonomic classification of phytoplankton sampled with imaging-in-flow cytometry. Limnol. Oceanogr: Methods 5, 204–216.
}
\seealso{
\code{\link{ifcb_py_install}} \url{https://github.com/kudelalab/PSD} \url{https://github.com/hsosik/ifcb-analysis}
}
