% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_replace_mat_values.R
\name{ifcb_replace_mat_values}
\alias{ifcb_replace_mat_values}
\title{Replace Values in MATLAB Classlist}
\usage{
ifcb_replace_mat_values(
  manual_folder,
  out_folder,
  target_id,
  new_id,
  column_index = 1,
  do_compression = TRUE
)
}
\arguments{
\item{manual_folder}{A character string specifying the path to the folder containing MAT classlist files to be updated.}

\item{out_folder}{A character string specifying the path to the folder where updated MAT classlist files will be saved.}

\item{target_id}{The target class ID to be replaced.}

\item{new_id}{The new class ID to replace the target ID.}

\item{column_index}{An integer value specifying which classlist column to edit. Default is 1 (manual).}

\item{do_compression}{A logical value indicating whether to compress the .mat file. Default is TRUE.}
}
\value{
This function does not return any value; it updates the classlist files in the specified directory.
}
\description{
This function replaces a target class ID with a new ID in MATLAB classlist files,
generated by the code in the \code{ifcb-analysis} repository (Sosik and Olson 2007).
}
\details{
This function requires a python interpreter to be installed. The required python packages can be installed in a virtual environment using \code{ifcb_py_install}.
}
\examples{
\dontrun{
# Initialize a python session if not already set up
ifcb_py_install()

# Replace class ID 99 with 1 in .mat classlist files
ifcb_replace_mat_values("output/manual", "output/manual", 99, 1, column_index = 1)
}
}
\references{
Sosik, H. M. and Olson, R. J. (2007), Automated taxonomic classification of phytoplankton sampled with imaging-in-flow cytometry. Limnol. Oceanogr: Methods 5, 204–216.
}
\seealso{
\code{\link{ifcb_py_install}} \url{https://github.com/hsosik/ifcb-analysis}
}
