% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ifcb_convert_filenames.R
\name{ifcb_convert_filenames}
\alias{ifcb_convert_filenames}
\title{Convert IFCB Filenames to Timestamps}
\usage{
ifcb_convert_filenames(filenames)
}
\arguments{
\item{filenames}{A character vector of IFCB filenames in the format "DYYYYMMDDTHHMMSS_IFCBxxx".}
}
\value{
A tibble with columns:
\itemize{
\item \code{sample}: The extracted sample name.
\item \code{full_timestamp}: The full timestamp in "YYYY-MM-DD HH:MM:SS" format.
\item \code{year}: The year as an integer.
\item \code{month}: The month as an integer.
\item \code{day}: The day as an integer.
\item \code{time}: The extracted time in "HH:MM:SS" format.
\item \code{ifcb_number}: The IFCB instrument number.
}
}
\description{
This function converts IFCB filenames to a data frame with separate columns for
the sample name, full timestamp, year, month, day, time, and IFCB number.
ROI numbers are included if available.
}
\examples{
filenames <- c("D20230314T001205_IFCB134", "D20230615T123045_IFCB135")
timestamps <- ifcb_convert_filenames(filenames)
print(timestamps)

}
