% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_linked.R
\name{load_linked}
\alias{load_linked}
\title{Import linked data into an \code{inzdf} object}
\usage{
load_linked(
  x,
  schema,
  con,
  name = ifelse(missing(con), deparse(substitute(x)), deparse(substitute(con))),
  keep_con = FALSE,
  progress = FALSE,
  ...
)
}
\arguments{
\item{x}{a linked specification file or vector of data set paths}

\item{schema}{a list describing the schema/relationships between the files}

\item{con}{a database connection to load the linked data into}

\item{name}{the name of the data set collection}

\item{keep_con}{if \code{TRUE} data will remain in DB (use for very large data)}

\item{progress}{either \code{TRUE} or \code{FALSE} to enable/disable the default progress bar, or a list of three functions to \code{x <- create(from, to)}, \code{set(x, i)}, and \code{destroy(x)} a progress bar.}

\item{...}{additional arguments passed to data reading function \code{smart_read()}}
}
\value{
an \code{inzdf} object
}
\description{
Import linked data into an \code{inzdf} object
}
