% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggiNEXT.R
\name{fortify.iNEXT}
\alias{fortify.iNEXT}
\title{Fortify method for classes from the iNEXT package.}
\usage{
\method{fortify}{iNEXT}(model, data = model$iNextEst, type = 1, ...)
}
\arguments{
\item{model}{\code{iNEXT} to convert into a dataframe.}

\item{data}{not used by this method}

\item{type}{three types of plots: sample-size-based rarefaction/extrapolation curve (\code{type = 1}); 
sample completeness curve (\code{type = 2}); coverage-based rarefaction/extrapolation curve (\code{type = 3}).}

\item{...}{not used by this method}
}
\description{
Fortify method for classes from the iNEXT package.
}
\examples{
data(spider)
# single-assemblage abundance data
out1 <- iNEXT(spider$Girdled, q=0, datatype="abundance")
ggplot2::fortify(out1, type=1)
}
