% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph_match_class.R
\name{\%*\%,graphMatch,ANY-method}
\alias{\%*\%,graphMatch,ANY-method}
\alias{\%*\%,ANY,graphMatch-method}
\alias{\%*\%,graphMatch,igraph-method}
\alias{\%*\%,igraph,graphMatch-method}
\title{Operator methods for graphMatch objects}
\usage{
\S4method{\%*\%}{graphMatch,ANY}(x, y)

\S4method{\%*\%}{ANY,graphMatch}(x, y)

\S4method{\%*\%}{graphMatch,igraph}(x, y)

\S4method{\%*\%}{igraph,graphMatch}(x, y)
}
\arguments{
\item{x}{Either graphMatch object or a matrix-like object}

\item{y}{Either graphMatch object or a matrix-like object}
}
\value{
These methods return an object of the same type
 as the non-graphMatch object. If m is the match of g1
 to g2 (both igraph objects), then m %*% g2 returns g2
 permuted so as to match with g1. Conversely, g1 %*% m
 returns g1 permuted so as to match with g2.
}
\description{
Methods to use \link[iGraphMatch:graphMatch]{graphMatch} objects as operators on
 igraph and matrix-like objects.
}
\examples{

set.seed(123)
cgnp_pair <- sample_correlated_gnp_pair(n = 10, corr =  0.3, p =  0.5)
g1 <- cgnp_pair$graph1
g2 <- cgnp_pair$graph2

# match g1 & g2 using FW methodology with indefinite relaxation
match <- gm(A = g1, B = g2, seeds = 1:3, method = 'indefinite')

# permute the second graph according to the match result: P \%*\% g2 \%*\% P^T
match \%*\% g2 # return an igraph object
# equivalent to the matrix operation
match[] \%*\% g2[] \%*\% t(match[])

match \%*\% g2[] # return a matrix
# equivalent to:
P <- match[]
P \%*\% g2[] \%*\% Matrix::t(P)

# the inverse operations are performed via right multiplication
all(g1[] \%*\% match == t(P) \%*\% g1[] \%*\% P)


}
