% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_break_down_uncertainty.R
\name{plot.break_down_uncertainty}
\alias{plot.break_down_uncertainty}
\title{Plot Generic for Break Down Uncertainty Objects}
\usage{
\method{plot}{break_down_uncertainty}(
  x,
  ...,
  vcolors = DALEX::colors_breakdown_drwhy(),
  show_boxplots = TRUE,
  max_features = 10
)
}
\arguments{
\item{x}{an explanation created with \code{\link{break_down_uncertainty}}}

\item{...}{other parameters.}

\item{vcolors}{If \code{NA} (default), DrWhy colors are used.}

\item{show_boxplots}{logical if \code{TRUE} (default) boxplot will be plotted to show uncertanity of attributions}

\item{max_features}{maximal number of features to be included in the plot. By default it's \code{10}.}
}
\value{
a \code{ggplot2} object.
}
\description{
Plot Generic for Break Down Uncertainty Objects
}
\examples{
library("DALEX")
library("iBreakDown")
set.seed(1313)
model_titanic_glm <- glm(survived ~ gender + age + fare,
                       data = titanic_imputed, family = "binomial")
explain_titanic_glm <- explain(model_titanic_glm,
                           data = titanic_imputed,
                           y = titanic_imputed$survived,
                           label = "glm")

sh_glm <- shap(explain_titanic_glm, titanic_imputed[1, ])

sh_glm
plot(sh_glm)

\dontrun{
## Not run:
library("randomForest")
set.seed(1313)

model <- randomForest(status ~ . , data = HR)
new_observation <- HR_test[1,]

explainer_rf <- explain(model,
                        data = HR[1:1000,1:5])

bd_rf <- break_down_uncertainty(explainer_rf,
                           new_observation,
                           path = c(3,2,4,1,5),
                           show_boxplots = FALSE)
bd_rf
plot(bd_rf, max_features = 3)

# example for regression - apartment prices
# here we do not have intreactions
model <- randomForest(m2.price ~ . , data = apartments)
explainer_rf <- explain(model,
                        data = apartments_test[1:1000,2:6],
                        y = apartments_test$m2.price[1:1000])

bd_rf <- break_down_uncertainty(explainer_rf,
                                     apartments_test[1,],
                                     path = c("floor", "no.rooms", "district",
                                         "construction.year", "surface"))
bd_rf
plot(bd_rf)

bd_rf <- shap(explainer_rf,
              apartments_test[1,])
bd_rf
plot(bd_rf)
plot(bd_rf, show_boxplots = FALSE)
}
}
\references{
Explanatory Model Analysis. Explore, Explain and Examine Predictive Models. \url{https://pbiecek.github.io/ema}
}
