% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{IARphiloglik}
\alias{IARphiloglik}
\title{Minus Log Likelihood of the IAR Model}
\usage{
IARphiloglik(x, y, st, delta_input, zeroMean = "TRUE", standarized = "TRUE")
}
\arguments{
\item{x}{A given phi coefficient of the IAR model.}

\item{y}{Array with the time series observations.}

\item{st}{Array with the irregular observational times.}

\item{delta_input}{Array with the measurements error standard deviations.}

\item{zeroMean}{logical; if true, the array y has zero mean; if false, y has a mean different from zero.}

\item{standarized}{logical; if true, the array y was standarized; if false, y contains the raw data}
}
\value{
Value of the negative log likelihood evaluated in phi.
}
\description{
This function return the negative log likelihood of the IAR Model for a specific value of phi.
}
\examples{

set.seed(6714)
st<-gentime(n=100)
y<-IARsample(phi=0.99,st=st,n=100)
y<-y$series
IARphiloglik(x=0.8,y=y,st=st,delta_input=c(0))
}
\references{
\insertRef{Eyheramendy_2018}{iAR}
}
\seealso{
\code{\link{gentime}}, \code{\link{IARsample}}
}
