% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{CIARsample}
\alias{CIARsample}
\title{Simulate from a CIAR Model}
\usage{
CIARsample(n, phiR, phiI, st, rho = 0L, c = 1L)
}
\arguments{
\item{n}{Length of the output time series. A strictly positive integer.}

\item{phiR}{Real part of the coefficient of CIAR model. A value between -1 and 1.}

\item{phiI}{Imaginary part of the coefficient of CIAR model. A value between -1 and 1.}

\item{st}{Array with observational times.}

\item{rho}{Correlation between the real and the imaginary part of the process. A value between -1 and 1.}

\item{c}{Nuisance parameter corresponding to the variance of the imaginary part.}
}
\value{
A list with the following components:
\itemize{
\item{y}{Array with the simulated real part of the CIAR process.}
\item{t}{ Array with observation times.}
\item{Sigma}{ Covariance matrix of the process.}
}
}
\description{
Simulates a CIAR Time Series Model
}
\details{
The chosen phiR and phiI values must satisfy the condition $|phiR + i phiI| < 1$.
}
\examples{
n=300
set.seed(6714)
st<-gentime(n)
x=CIARsample(n=n,phiR=0.9,phiI=0,st=st,c=1)
plot(st,x$y,type='l')
x=CIARsample(n=n,phiR=-0.9,phiI=0,st=st,c=1)
plot(st,x$y,type='l')
}
\references{
\insertRef{Elorrieta_2019}{iAR}
}
\seealso{
\code{\link{gentime}}
}
