% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cube.R
\docType{methods}
\name{remove.aggregation}
\alias{remove.aggregation}
\alias{remove.aggregation,Cube-method}
\title{Removes aggregations from a hypercube}
\usage{
remove.aggregation(x, dimensions = NA, last = FALSE)
}
\arguments{
\item{x}{Hypercube from which the aggregation will be removed.}

\item{dimensions}{A vector of dimensions for which the aggregations will be removed.}

\item{last}{Should the last aggregation be removed? If this parameter is set TRUE, the dimension vector will be ignored.}
}
\value{
Returns a \code{Cube} object with the added aggregation.
}
\description{
This function removes aggregations from a hypercube.
The cube itself will not be changed. The aggregation only affect the data that
will be shown when printing the cube.
}
\examples{

data("sales")
cube = generateCube(sales, columns = list(time = c("month", "year"),
      location = c("state"), product = "product"), valueColumn = "amount")
cube = add.aggregation(cube, dimensions = c("month", "year"), fun = "sum")
cube
cube = add.aggregation(cube, dimensions = "year", fun = "sum")
cube
cube = remove.aggregation(cube, dimensions = "year")
cube

}
\seealso{
\code{\link[=Cube-class]{Cube}} \code{\link{add.aggregation}} \code{\link{remove.selection}}
}
\author{
Michael Scholz \email{michael.scholz@uni-passau.de}
}
\keyword{methods}
