% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/show.R
\docType{methods}
\name{as.character,hyperSpec-method}
\alias{as.character,hyperSpec-method}
\alias{as.character}
\alias{show}
\alias{show,hyperSpec-method}
\alias{print,hyperSpec-method}
\alias{print}
\alias{summary,hyperSpec-method}
\alias{summary}
\title{Convert a hyperSpec object to character strings for Display
\code{print}, \code{show}, and \code{summary} show the result of
\code{as.character}.}
\usage{
\S4method{as.character}{hyperSpec}(x, digits = getOption("digits"),
  range = TRUE, max.print = 5, shorten.to = c(2, 1))

\S4method{show}{hyperSpec}(object)

\S4method{print}{hyperSpec}(x, range = FALSE, ...)

\S4method{summary}{hyperSpec}(object, ...)
}
\arguments{
\item{x}{a \code{hyperSpec} object}

\item{digits}{number of digits handed over to \code{format}}

\item{range}{should the values be indicated as range rather then first and
last elements?}

\item{max.print}{maximum number of elements to be printed (of a variable)}

\item{shorten.to}{if a vector is longer than \code{max.print}, only the
first \code{shorten.to[1]} and the last \code{shorten.to[2]} elements are
printed}

\item{object}{a \code{hyperSpec} object}

\item{...}{\code{print} and \code{summary}  hand further arguments to \code{as.character}}
}
\value{
\code{as.character} returns a character vector fit to be printed by
  \code{cat} with \code{sep = "\n"}.

\code{print} invisibly returns \code{x} after printing, \code{show} returns
  an invisible \code{NULL}.
}
\description{
\code{print}, \code{show}, and \code{summary} differ only in the defaults.
\code{show} displays the range of values instead,

\code{print} shows the overview giving the first and last values of each
data column (fastest).

\code{summary} displays the logbook in addition.
}
\examples{

chondro

show (chondro)

summary (chondro)

print (chondro, range = TRUE)

}
\seealso{
\code{\link[base]{as.character}}

\code{\link[methods]{show}}

\code{\link[base]{print}}

\code{\link[base]{summary}}
}
\keyword{methods}
\keyword{print}
