% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spc.spline.R
\name{spc.smooth.spline}
\alias{spc.smooth.spline}
\title{Spectral smoothing by splines}
\usage{
spc.smooth.spline(spc, newx = wl(spc), ...)
}
\arguments{
\item{spc}{hyperSpec object}

\item{newx}{wavelengh axis to interpolate on}

\item{...}{further parameters handed to \code{\link[stats]{smooth.spline}}}
}
\value{
hyperSpec object containing smoothed spectra
}
\description{
Smoothing splines
}
\details{
Spectral smoothing by splines
}
\note{
This function is still experimental
}
\examples{
p <- paracetamol [,,2200 ~ max]
plot (p, col = "gray")
smooth <- spc.smooth.spline (p [,, c (2200 ~ 2400, 2500 ~ 2825, 3150 ~ max)],
                             wl (paracetamol [,, 2200 ~ max]),
                             df = 4, spar = 1)
plot (smooth, col = "red", add = TRUE)

plot (p - smooth)

}
\author{
Claudia Beleites
}
\seealso{
\code{\link[hyperSpec]{spc.loess}}

\code{\link[stats]{smooth.spline}}
}

