% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_index_ids.R
\name{make_index_ids}
\alias{make_index_ids}
\alias{make_index_ids.data.frame}
\alias{make_index_ids.hy}
\title{Make Index ids}
\usage{
make_index_ids(x, long_form = FALSE)

\method{make_index_ids}{data.frame}(x, long_form = FALSE)

\method{make_index_ids}{hy}(x, long_form = FALSE)
}
\arguments{
\item{x}{data.frame network compatible with \link{hydroloom_names}.}

\item{long_form}{logical if TRUE, return will be a long-form version of the
\code{to_list}. This form can be converted to the default list format with
\link{format_index_ids}.}
}
\value{
list containing named elements: \code{to}: adjacency matrix \code{lengths}:
vector indicating the number of connections from each node, and: \code{to_list}:
a data.frame with an \code{id}, \code{indid} and a \code{toindid} list column. If long_form
= TRUE, return will be a long form data.frame with no list column as in \code{to_list}.
NOTE: the long_form output should be used with caution as indid may not
correspond to row number.
}
\description{
makes index ids for the provided hy object. These can be used
for graph traversal algorithms such that the row number and id are equal.
}
\examples{

x <- data.frame(id = c(1, 2, 3, 4, 5, 6, 7, 8, 9),
              toid = c(2, 3, 4, 5, 0, 7, 8, 9, 4))

make_index_ids(x)

x <- hy(sf::read_sf(system.file("extdata/new_hope.gpkg", package = "hydroloom")))

x <- add_toids(x, return_dendritic = FALSE)

x <- make_index_ids(x)

names(x)
class(x$to)
class(x$lengths)
class(x$to_list)
is.list(x$to_list$toindid)

}
