% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waterLevel.R, R/waterLevelPegelonline.R
\name{waterLevel}
\alias{waterLevel}
\alias{waterLevelPegelonline}
\title{Compute a 1d water level dataset}
\usage{
waterLevel(wldf, shiny = FALSE)

waterLevelPegelonline(wldf, shiny = FALSE)
}
\arguments{
\item{wldf}{an object of class \linkS4class{WaterLevelDataFrame}.}

\item{shiny}{\code{logical} determing whether columns (\code{section},
\code{weight_x}, \code{weight_y}) relevant for the
\code{\link{plotShiny}()}-function are appended to the resulting
\linkS4class{WaterLevelDataFrame}.}
}
\value{
An object of class \linkS4class{WaterLevelDataFrame}.
}
\description{
Functions to compute 1d water level information and store it as
  column \code{w} of an S4 object of type \linkS4class{WaterLevelDataFrame}.
}
\details{
\code{waterLevel} interpolates 1d water level along the river axis
  of Elbe and Rhine based on daily averaged, mostly validated gauging data
  stored in the internal dataset \code{\link{df.gauging_data}}. Internally
  stored gauging data are available from 1960-01-01 until yesterday.

  \code{waterLevelPegelonline} carries out the interpolation with gauging
  data obtained through a
  \href{https://en.wikipedia.org/wiki/Representational_state_transfer}{REST}
  service from \url{https://pegelonline.wsv.de/gast/start}. The gauging data
  from \href{https://pegelonline.wsv.de/gast/start}{PEGELONLINE} have a high
  temporal resolution of 15 minutes, enabling meaningful linear temporal
  interpolation. Since data from
  \href{https://pegelonline.wsv.de/gast/start}{PEGELONLINE}
  expire after 31 days, this function is only applicable for
  \linkS4class{WaterLevelDataFrame}s with a \code{time}-slot set to
  appropriate values within the last 31 days before function call.
}
\examples{
\dontshow{if (hyd1d:::.pegelonline_status()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# waterLevel
wldf <- WaterLevelDataFrame(river   = "Elbe",
                            time    = as.POSIXct("2016-12-21"),
                            station = seq(257, 262, 0.1))
wldf <- waterLevel(wldf)

# waterLevelPegelonline
wldf1 <- wldf
setTime(wldf1) <- Sys.time() - as.difftime(60, units = "mins")
wldf1 <- waterLevelPegelonline(wldf1)
\dontshow{\}) # examplesIf}
}
\references{
\insertRef{busch_einheitliche_2009}{hyd1d}
  
  \insertRef{hkv_hydrokontor_erstellung_2014}{hyd1d}
  
  \insertRef{bundesanstalt_fur_gewasserkunde_flys_2016}{hyd1d}
  
  \insertRef{wsv_pegelonline_2018}{hyd1d}
}
\seealso{
\code{\link{plotShiny}}
}
