% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ws_subset.R
\name{ws_subset}
\alias{ws_subset}
\title{Subset ORNL DAAC HWSD data}
\usage{
ws_subset(
  location = c(32, -81, 34, -80),
  site = "HWSD",
  param = "ALL",
  path = tempdir(),
  internal = TRUE,
  rate = 0.1
)
}
\arguments{
\item{location}{location of a bounding box c(lat, lon, lat, lon) defined
by a bottom-left and top-right coordinates, a single location (lat, lon)
or a data frame with various locations listed (site, lat, lon)}

\item{site}{sitename for the extracted location}

\item{param}{soil parameters to provide, the default setting is ALL, this 
will download all available soil parameters.Check
https://daac.ornl.gov/SOILS/guides/HWSD.html for parameter descriptions.}

\item{path}{path where to download the data to (only applicable to
spatial data)}

\item{internal}{do not store the data on disk}

\item{rate}{request rate in seconds, determines how long to wait between 
queries to avoid bouncing because of rate limitations}
}
\value{
Local geotiff data, or a data frame with HWSD soil information
}
\description{
Subset function to query pixel or spatial data from the
ORNL DAAC HWSD THREDDS server. Returns a tidy data frame
for point locations or raster data to the workspace or
disk.
}
\examples{

\dontrun{
 # extract sand fraction values
 # for a point location
 values <- ws_subset(
    site = "HWSD",
    location = c(34, -81),
    param = "T_SAND"
   )
   
 print(values)
 
 # Download a soil fraction map
 # of sand for a given bounding box
 t_sand <- ws_subset(
    site = "HWSD",
    location = c(32, -81, 34, -80),
    param = "T_SAND",
    path = tempdir(),
    internal = TRUE
   )
   
 raster::plot(t_sand)
}
}
