% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/html.R
\name{print_html}
\alias{print_html}
\alias{print_notebook}
\alias{to_html}
\alias{as_html}
\title{Create HTML representing a huxtable}
\usage{
print_html(ht, ...)

print_notebook(ht, ...)

to_html(ht, ...)

as_html(ht, ...)
}
\arguments{
\item{ht}{A huxtable.}

\item{...}{Arguments passed to methods. Not currently used.}
}
\value{
\code{to_html} returns an HTML string. \code{as_html} wraps \code{to_html} and returns an
\code{htmltools::HTML} object. \code{print_html} prints the string and returns \code{NULL}.

\code{print_notebook} prints HTML output suitable for use in an
RStudio interactive notebook.
}
\description{
These functions print or return an HTML table. \code{print_html} also prepends a
\verb{<style>} block defining basic CSS classes.
}
\examples{
ht <- hux(a = 1:3, b = letters[1:3])
to_html(ht)
as_html(ht)
}
\seealso{
Other printing functions: 
\code{\link{print_latex}()},
\code{\link{print_md}()},
\code{\link{print_rtf}()},
\code{\link{print_screen}()},
\code{\link{print_typst}()}
}
\concept{printing functions}
