% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties-border-get.R,
%   R/properties-border-set-map.R
\name{left_border}
\alias{left_border}
\alias{right_border}
\alias{top_border}
\alias{bottom_border}
\alias{left_border<-}
\alias{right_border<-}
\alias{top_border<-}
\alias{bottom_border<-}
\alias{borders}
\alias{set_left_border}
\alias{set_right_border}
\alias{set_top_border}
\alias{set_bottom_border}
\alias{map_left_border}
\alias{map_right_border}
\alias{map_top_border}
\alias{map_bottom_border}
\title{Set borders}
\usage{
left_border(ht)

right_border(ht)

top_border(ht)

bottom_border(ht)

left_border(ht) <- value

right_border(ht) <- value

top_border(ht) <- value

bottom_border(ht) <- value

set_left_border(ht, row, col, value = 0.4)

set_right_border(ht, row, col, value = 0.4)

set_top_border(ht, row, col, value = 0.4)

set_bottom_border(ht, row, col, value = 0.4)

map_left_border(ht, row, col, fn)

map_right_border(ht, row, col, fn)

map_top_border(ht, row, col, fn)

map_bottom_border(ht, row, col, fn)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A numeric thickness or a \code{\link[=brdr]{brdr()}} object. Set to \code{NA} to reset to the default, which is \code{0}.}

\item{row}{A row specifier. See \link{rowspecs} for details.}

\item{col}{An optional column specifier.}

\item{fn}{A mapping function. See \link{mapping-functions} for details.}
}
\description{
These functions set borders between cells.
}
\details{
Borders are always "collapsed": \code{right_border(ht)[, 1]} is the same as
\code{left_border(ht)[, 2]}, and setting one sets the other.

Setting \code{left_border(ht) <- number} sets the border thickness. You can set
multiple properties at once by using \code{\link[=brdr]{brdr()}}.

Currently in LaTeX, all non-zero border widths on a given line must be the
same.
}
\section{Limitations}{

\itemize{
\item In HTML, you will need to set a width of at least 3 to get a double border.
\item Only "solid" and "double" styles are currently implemented in LaTeX, and
all non-zero horizontal border widths on a given line must be the same.
}
}

\examples{
bottom_border(jams)[1, ] <- 0.4
jams

bottom_border(jams)[1, ] <- brdr(0.4, "solid", "blue")
jams

set_bottom_border(jams, brdr(0.4, "solid", "green"))

}
\seealso{
\link{set-multiple}

Other border properties: 
\code{\link{left_border_color}()},
\code{\link{left_border_style}()}
}
\concept{border properties}
