% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties-cell.R
\name{align}
\alias{align}
\alias{align<-}
\alias{set_align}
\alias{map_align}
\title{Set the horizontal alignment of cell content}
\usage{
align(ht)
align(ht) <- value
set_align(ht, row, col, value )
map_align(ht, row, col, fn)
}
\arguments{
\item{ht}{A huxtable.}

\item{row}{A row specifier. See \link{rowspecs} for details.}

\item{col}{An optional column specifier.}

\item{fn}{A mapping function. See \link{mapping-functions} for details.}

\item{value}{A character vector or matrix.

Set to \code{NA} to reset to the default, which is \code{"left"}.}
}
\value{
\code{align()} returns the \code{align} property.
\code{set_align()} returns the modified huxtable.
}
\description{
Values may be "left", "center", "right", \code{NA} or a single character. If
\code{value} is a single character (e.g. a decimal point), then the cell is
aligned on this character.
}
\details{
Neither HTML nor LaTeX currently possess reliable ways of aligning cells
on a decimal point. Huxtable does this by padding with spaces. This may
work better if you use a fixed-width font.
}
\examples{

numbers <- c(1, 1.5, 1.03, 10, 10.01)
number_hux <- as_hux(matrix(numbers, 5, 4))
number_format(number_hux) <- "\%.4g"

number_hux <- map_align(number_hux,
      by_cols("left", "center", "right", "."))

alignments <- c("left", "centre", "right", "decimal (.)")
number_hux <- rbind(
        alignments,
        number_hux
      )
number_hux

}
