% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/properties.R
\name{align}
\alias{align}
\alias{align<-}
\alias{set_align}
\alias{map_align}
\title{Alignment}
\usage{
align(ht)
align(ht) <- value
set_align(ht, row, col, value, byrow = FALSE)
map_align(ht, row, col, fn)
}
\arguments{
\item{ht}{A huxtable.}

\item{value}{A character vector or matrix which may be "left", "center", "right" , \code{NA} or a single character.

Set to \code{NA} to reset to the default, which is \code{"left"}.}

\item{row}{A row specifier. See \link{rowspecs} for details.}

\item{col}{An optional column specifier.}

\item{fn}{A mapping function. See \link{mapping-functions} for details.}

\item{byrow}{Deprecated. Use \code{\link[=by_cols]{by_cols()}} instead.}
}
\value{
For \code{align}, the \code{align} property.
For \code{set_align} and \code{map_align}, the modified huxtable.
}
\description{
Functions to get or set the \emph{alignment} property of huxtable cells.
}
\details{
This sets the horizontal alignment of the cell. If \code{value} is a single character (e.g.
a decimal point), then the cell is aligned on this character.
}
\examples{

align(jams) <-  "right"
align(jams)


set_align(jams, "right")
set_align(jams,
      2:3, 1, "right")
map_align(jams,
      by_rows("right", "left"))
}
