% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/attributes.R
\name{set_cell_properties}
\alias{set_cell_properties}
\title{Set multiple cell properties}
\usage{
set_cell_properties(ht, row, col, ...)
}
\arguments{
\item{ht}{A huxtable.}

\item{row}{A row specification.}

\item{col}{A column specification.}

\item{...}{Named list of property values.}
}
\value{
The modified huxtable object.
}
\description{
Set multiple cell properties
}
\examples{
ht <- hux(a = 1:3, b = 1:3)
ht <- set_cell_properties(ht, 1, 1, font = 'Palatino', font_size = 14)
font(ht)
font_size(ht)
}
