% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/empty.R
\name{allNA}
\alias{allNA}
\title{Is a vector empty?}
\usage{
allNA(
  x,
  expected = FALSE,
  len0 = FALSE,
  nThread = getOption("hutilscpp.nThread", 1L)
)
}
\arguments{
\item{x}{A vector. Only atomic vectors are supported.}

\item{expected}{\code{TRUE | FALSE} Whether it is expected that \code{x} is empty.
If \code{TRUE} the function will be marginally faster if \code{x} is empty but
likely slower if not.}

\item{len0}{The result if \code{length(x) == 0}.}

\item{nThread}{Number of threads to use (only applicable if \code{expected} is \code{TRUE})}
}
\description{
A vector is empty if \code{all(is.na(x))} with a
special case for \code{length(x) == 0}.
}
\examples{
allNA(c(NA, NA))
allNA(c(NA, NA, 1))

}
