% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/implies.R
\name{implies}
\alias{implies}
\alias{\%implies\%}
\title{#' Logical implies}
\usage{
implies(x, y)

x \%implies\% y
}
\arguments{
\item{x, y}{Logical vectors of the same length.}
}
\value{
Logical implies: \code{TRUE} unless \code{x} is \code{TRUE} and \code{y} is \code{FALSE}.

\code{NA} in either \code{x} or \code{y} results in \code{NA} if and only if the result is unknown.
In particular \code{NA \%implies\% TRUE} is \code{TRUE} and \code{FALSE \%implies\% NA} is \code{TRUE}.

If \code{x} or \code{y} are length-one, the function proceeds as if the length-one vector were recycled
to the length of the other.
}
\description{
Returns the result of \eqn{x\Longrightarrow y}.
}
\examples{
 
library(data.table)
CJ(x = c(TRUE,
         FALSE),
   y = c(TRUE,
         FALSE))[, ` x => y` := x \%implies\% y][]

#>        x     y  x => y
#> 1: FALSE FALSE    TRUE
#> 2: FALSE  TRUE    TRUE
#> 3:  TRUE FALSE   FALSE
#> 4:  TRUE  TRUE    TRUE

# NA results:
#> 5:    NA    NA      NA
#> 6:    NA FALSE      NA
#> 7:    NA  TRUE    TRUE
#> 8: FALSE    NA    TRUE
#> 9:  TRUE    NA      NA
}
