% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_pattern.R
\name{find_pattern_in}
\alias{find_pattern_in}
\title{Find string pattern in (text) file}
\usage{
find_pattern_in(file_contents, basedir = ".", reader = readLines,
  include.comments = FALSE, file.ext = "\\\\.(R|r)(nw|md)?$")
}
\arguments{
\item{file_contents}{A perl-regular expression as a search query.}

\item{basedir}{The root of the directory tree in which files will be searched recursively.}

\item{reader}{A function, akin to \code{base::readLines}, the default, that accepts a filename and returns a character vector.}

\item{include.comments}{If \code{FALSE}, the default, comments (i.e. anything after a \code{\#}) are not searched.}

\item{file.ext}{A regular expression passed to \code{list.files(pattern = file.ext)}. 
By default, \code{"\\.(R|r)(nw|md)?$"}, i.e. all R and Sweave files.}
}
\value{
A \code{data.table}, one row per filename with a match, including the first line that matched.
}
\description{
Find string pattern in (text) file
}
