% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humidity.R
\name{WVP2}
\alias{WVP2}
\title{calculate partial water vapor pressure given relative humidity and saturation water vapor pressure}
\usage{
WVP2(psi, Es)
}
\arguments{
\item{psi}{relative humidity \eqn{\psi} in percentage (\eqn{\%})}

\item{Es}{saturation vapor pressure \eqn{e_s}(hPa) at temperature \eqn{t}, which can be calculated by callling \code{\link{SVP}} function.}
}
\value{
numeric partial water vapor pressure in Pascal (Pa)
}
\description{
calculate partial water vapor pressure \eqn{e} based on relative humdity \eqn{\psi} and saturation water vapor pressure at temperature \eqn{t}
}
\examples{
Es <- SVP(273.15)
WVP2(70, Es)
}
\seealso{
\code{\link{SVP}}, \code{\link{SVP.ClaCla}}, \code{\link{SVP.Murray}}.
}
\author{
Jun Cai (\email{cai-j12@mails.tsinghua.edu.cn}), PhD candidate from
Department of Earth System Science, Tsinghua University
}
