% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{Band.gene}
\alias{Band.gene}
\title{Retrieve the cytoband(s) for genes labels}
\usage{
Band.gene(genes, build = NULL, dir = getwd(), append.chr = TRUE,
  data.frame = FALSE, warnings = TRUE)
}
\arguments{
\item{genes}{character, an optional vector of gene ids, or RangedData/GRanges object}

\item{build}{character, "hg18" or "hg19" (or 36/37) to show which reference to retrieve. The 
default when build is NULL is to use the build from the current ChipInfo annotation}

\item{dir}{character, 'dir' is the location to download cyto annotation information; if left as
NULL, depending on the value of getOption("save.annot.in.current"), the annotation will either
be saved in the working directory to speed-up subsequent lookups, or deleted after use.}

\item{append.chr}{logical, it is typical that the chromosome character preceeds cytoband labels,
but if this parameter is set to FALSE, it will be left off.}

\item{data.frame}{logical, if data.frame is true, instead of returning a vector of full cytoband
labels, a data.frame will be returned.}

\item{warnings}{logical, if warnings=FALSE and SNP ids are entered instead of Gene labels,
then the function will automatically detect this and return the result of Band(snps='genes')}
}
\value{
Returns a vector of bands, if any entries span more than one band, the bands will be
concatenated as character type, delimited by semicolons (;). If data.frame is true, instead of 
returning a vector of full cytoband labels, a data.frame will be returned with a 'chr'
[chromosome] column, 'band' cytoband label  without the chromosome prefix, and rownames 
equal to 'genes'
}
\description{
Allows retrieval of the the cytoband/karyotype label for HGNC gene labels.
}
\examples{
\donttest{
setwd(tempdir())
a.few.snps <- c("rs3842724","imm_11_2147527","rs9467354")
Band.gene("HLA-C") # using chr,pos vectors
Band.gene(a.few.snps)  # fails with warning as these are SNPs, not genes
Band.gene(a.few.snps,warnings=FALSE) # with warnings=FALSE this continues with snps entered
Band.gene("SLC6A4")  # serotonin gene [5-HTT]
Band.gene("SLC6A4",append.chr=FALSE)
Band.gene("SLC6A4",data.frame=TRUE)
}
}
\seealso{
\code{\link{Chr}}, \code{\link{Pos}}, \code{\link{Pos.gene}}, \code{\link{Band}}, 
\code{\link{Band.gene}}, \code{\link{Band.pos}}, \code{\link{Gene.pos}}
}
\author{
Nicholas Cooper \email{nick.cooper@cimr.cam.ac.uk}
}
