% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{GENE.to.ENS}
\alias{GENE.to.ENS}
\title{Convert gene ids to ensembl ids}
\usage{
GENE.to.ENS(genes, dir = NULL, ...)
}
\arguments{
\item{genes}{character, gene labels, e.g, "APOE"}

\item{dir}{character, 'dir' is the location to download gene and cytoband information; if
left as NULL, depending on the value of getOption("save.annot.in.current"), the annotation
will either be saved in the working directory to speed-up subsequent lookups, or deleted 
after use.}

\item{...}{further arguments to get.gene.annot()}
}
\value{
Returns a vector of HGNC gene ids corresponding to the 'ens' ensembl ids entered,
any ids not found will be returned as NA.
}
\description{
Retrieve the ensembl IDs corresponding to a list of common gene names (HGNC format).
}
\examples{
\donttest{
setwd(tempdir())
gene.ids <- c("MYC","PTPN2","IL2RA","APOE")
GENE.to.ENS(gene.ids)
}
}
\author{
Nicholas Cooper \email{nick.cooper@cimr.cam.ac.uk}
}
\seealso{
\code{\link{GENE.to.ENS}}, \code{\link{rs.to.id}}, \code{\link{id.to.rs}}; eg2sym, sym2eg from package 'gage'
}

