% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/humarray.R
\name{Pos.gene}
\alias{Pos.gene}
\title{Find the chromosome, start and end position for gene names}
\usage{
Pos.gene(genes, build = NULL, dir = NULL, bioC = FALSE, band = FALSE,
  one.to.one = TRUE, remap.extra = FALSE, discard.extra = TRUE,
  warnings = TRUE)
}
\arguments{
\item{genes}{character, a vector of gene ids}

\item{build}{character, "hg18" or "hg19" (or 36/37) to show which reference to retrieve. The 
default when build is NULL is to use the build from the current ChipInfo annotation}

\item{dir}{character, 'dir' is the location to download gene annotation information to; if left as
NULL, depending on the value of getOption("save.annot.in.current"), the annotation will either
be saved in the working directory to speed-up subsequent lookups, or deleted after use.}

\item{bioC}{logical, if true then return position information as a GRanges object, else 
a data.frame}

\item{band}{logical, whether to include band/stripe in returned object}

\item{one.to.one}{logical, some genes have split ranges, TRUE merges these to give only 1 range 
per gene, NB: this is the default behaviour when using the more general Pos() function}

\item{remap.extra}{logical, if TRUE genes with chromosome annotation 'c6_cox' and 'c6_QBL' will
be mapped to chromosome 6, and 'NT_xxxx' chromosome labels will all be mapped to 'Z_NT', etc}

\item{discard.extra}{logical, if TRUE then any gene hit with chromosome not in 1:22, X, Y, XY, MT, 
will be discarded.}

\item{warnings}{logical, whether to show warnings when some/all ids are not matched to the 
reference}
}
\value{
Returns a data.frame with columns 'chr' [chromosome], 'start' [starting position of the
 gene],'end' [end position of the gene], or if bioC=TRUE, then returns a GRanges object with
 equivalent information, and if band=TRUE, then an extra column is added with band information
 If returning a data.frame, then it will be in the same order as 'genes'. If bioC=TRUE, then
 the result will be in genome order, regardless of the order of 'genes'.
}
\description{
Allows retrieval of the the chromosome position associated with a HGNC gene label, 
 or vector of such labels. Note that the position returned for genes is not a 
 single point as for SNPs, so the result will be a chromosome, then a position range with
 start and end.
}
\examples{
\donttest{
setwd(tempdir())
Pos.gene(c("CTLA4","PTPN22"))
Pos.gene("MYC",build=36)
Pos.gene("MYC",build=37)
Pos.gene(c("CTLA4","PTPN22"),bioC=TRUE,band=TRUE)
Pos.gene(c("CTLA4","OR2A1"),one.to.one=TRUE,build=38) # OR2A1 is split over two ranges
Pos.gene(c("CTLA4","OR2A1"),one.to.one=FALSE,build=38)
Pos.gene("RNU2-1",one.to.one=FALSE,bioC=TRUE,build=38) # RNU2-1 is split over multiple ranges
}
}
\author{
Nicholas Cooper \email{nick.cooper@cimr.cam.ac.uk}
}
\seealso{
\code{\link{Chr}}, \code{\link{Pos}}, \code{\link{Pos.band}}, \code{\link{Band}}, 
\code{\link{Band.gene}}, \code{\link{Band.pos}}, \code{\link{Gene.pos}}
}

