% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/doApiQuery.R
\name{doApiQuery}
\alias{doApiQuery}
\title{Main internal functions for querying the Hub'Eau API endpoints}
\usage{
doApiQuery(api, endpoint, ..., params)
}
\arguments{
\item{api}{a \link{character} name of the API (e.g.: "indicateurs_services", "prelevements"...), see example for available APIs}

\item{endpoint}{a \link{character} name of the endpoint, see example for available endpoints in an API}

\item{...}{parameters of the queries and their values in the format
\verb{Param1_Name = "Param1 value", Param2_Name = "Param2 value"}, use the
function \link{list_params} for a list of the available filter parameters
for a given API endpoint and see the API documentation for their description}

\item{params}{(deprecated) a \link{list} the list of parameters of the queries and their
values in the format \code{list(ParamName = "Param value", ...)}. This parameter
is replaced by the parameter \code{...}}
}
\value{
A \link{list} with the concatenated results returned by the API.
}
\description{
The function \code{doQueryApi} is called by all the function querying the API
endpoints and return the raw data sent by the endpoint.
}
\details{
Pagination of the queries is handled automatically and the returned \link{list} is
the concatenation of all the results sent by the API.

The functions \verb{get_[api]_[endpoint]} call the function \code{doQueryApi}
and parse the response in a \link[tibble:tibble]{tibble::tibble} format for the user (See \link{convert_list_to_tibble}).

By default the user agent used for the query is "https://github.com/inrae/hubeau".
You can redefined the user agent with the global option
"hubeau.user_agent": \code{options(hubeau.user_agent = "My user agent")}.
}
\examples{
# To get the available APIs in the package
list_apis()

# To get the available endpoints in an API
list_endpoints("prelevements")

# To get available parameters in endpoint "chroniques" of the API "prelevements"
list_params(api = "prelevements", endpoint = "chroniques")

# To query the endpoint "chroniques" of the API "prelevements"
# on all devices in the commune of Romilly-sur-Seine in 2018
\dontrun{
resp <- doApiQuery(api = "prelevements",
                   endpoint = "chroniques",
                   code_commune_insee = "10323",
                   annee = "2018")
convert_list_to_tibble(resp)
}
}
