% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oauth-flow-auth-code.R
\name{oauth_flow_auth_code}
\alias{oauth_flow_auth_code}
\alias{oauth_flow_auth_code_url}
\alias{oauth_flow_auth_code_listen}
\alias{oauth_flow_auth_code_parse}
\alias{oauth_flow_auth_code_pkce}
\title{OAuth flow: authorization code}
\usage{
oauth_flow_auth_code(
  client,
  auth_url,
  scope = NULL,
  pkce = TRUE,
  auth_params = list(),
  token_params = list(),
  host_name = "localhost",
  host_ip = "127.0.0.1",
  port = httpuv::randomPort()
)

oauth_flow_auth_code_url(
  client,
  auth_url,
  redirect_uri = NULL,
  scope = NULL,
  state = NULL,
  auth_params = list()
)

oauth_flow_auth_code_listen(host_ip = "127.0.0.1", port = 1410)

oauth_flow_auth_code_parse(query, state)

oauth_flow_auth_code_pkce()
}
\arguments{
\item{client}{An \code{\link[=oauth_client]{oauth_client()}}.}

\item{auth_url}{Authorization url; you'll need to discover this by reading
the documentation.}

\item{scope}{Scopes to be requested from the resource owner.}

\item{pkce}{Use "Proof Key for Code Exchange"? This adds an extra layer of
security and should always be used if supported by the server.}

\item{auth_params}{List containing additional parameters passed to \code{oauth_flow_auth_code_url()}}

\item{token_params}{List containing additional parameters passed to the
\code{token_url}.}

\item{host_name}{Host name used to generate \code{redirect_uri}}

\item{host_ip}{IP address web server will be bound to.}

\item{port}{Port to bind web server to. By default, this uses a random port.
You may need to set it to a fixed port if the API requires that the
\code{redirect_uri} specified in the client exactly matches the \code{redirect_uri}
generated by this function.}

\item{redirect_uri}{URL to which user should be redirected.}

\item{state}{Random state generated by \code{oauth_flow_auth_code()}. Used to
verify that we're working with an authentication request that we created.
(This is an unlikely threat for R packages since the webserver that
listens for authorization responses is transient.)}

\item{query}{List of query parameters returned by \code{oauth_flow_auth_code_listen()}.}
}
\value{
An \link{oauth_token}.
}
\description{
These functions implement the OAuth authorization code flow, as defined
by \href{https://datatracker.ietf.org/doc/html/rfc6749#section-4.1}{rfc6749},
Section 4.1. This is the most commonly used OAuth flow where the user is
opens a page in their browser, approves the access, and then returns to R.

\code{oauth_flow_auth_code()} is a high-level wrapper that should
work with APIs that adhere relatively closely to the spec. The remaining
low-level functions can be used to assemble a custom flow for APIs that are
further from the spec:
\itemize{
\item \code{oauth_flow_auth_code_url()} generates the url where the user is sent.
\item \code{oauth_flow_auth_code_listen()} starts an webserver that listens for
the response from the resource server.
\item \code{oauth_flow_auth_code_parse()} parses the query parameters returned from
the server redirect, verifying that the \code{state} is correct, and returning
the authorisation code.
\item \code{oauth_flow_auth_code_pkce()} generates code verifier, method, and challenge
components as needed for PKCE, as defined in
\href{https://datatracker.ietf.org/doc/html/rfc7636}{rfc7636}.
}
}
\examples{
client <- oauth_client(
  id = "28acfec0674bb3da9f38",
  secret = obfuscated(paste0(
     "J9iiGmyelHltyxqrHXW41ZZPZamyUNxSX1_uKnv",
     "PeinhhxET_7FfUs2X0LLKotXY2bpgOMoHRCo"
  )),
  token_url = "https://github.com/login/oauth/access_token",
  name = "hadley-oauth-test"
)
if (interactive()) {
  token <- oauth_flow_auth_code(client, auth_url = "https://github.com/login/oauth/authorize")
  token
}
}
\seealso{
Other OAuth flows: 
\code{\link{oauth_flow_bearer_jwt}()},
\code{\link{oauth_flow_client_credentials}()},
\code{\link{oauth_flow_device}()},
\code{\link{oauth_flow_password}()},
\code{\link{oauth_flow_refresh}()}
}
\concept{OAuth flows}
\keyword{internal}
