% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/http-post.r
\name{POST}
\alias{POST}
\title{POST file to a server.}
\usage{
POST(url = NULL, config = list(), ..., body = NULL,
  encode = c("multipart", "form", "json"), multipart = TRUE,
  handle = NULL)
}
\arguments{
\item{url}{the url of the page to retrieve}

\item{config}{Additional configuration settings such as http
authentication (\code{\link{authenticate}}), additional headers
(\code{\link{add_headers}}), cookies (\code{\link{set_cookies}}) etc.
See \code{\link{config}} for full details and list of helpers.}

\item{...}{Further named parameters, such as \code{query}, \code{path}, etc,
passed on to \code{\link{modify_url}}. Unnamed parameters will be combined
with \code{\link{config}}.}

\item{body}{One of the following:
\itemize{
  \item \code{FALSE}: No body
  \item \code{NULL}: An empty body
  \item \code{""}: A length 0 body
  \item \code{upload_file("path/")}: The contents of a file.  The mime
    type will be guessed from the extension, or can be supplied explicitly
    as the second argument to \code{upload_file()}
  \item A character or raw vector: sent as is in body. Use
    \code{\link{content_type}} to tell the server what sort of data
    you are sending.
  \item A named list: See details for encode.
}}

\item{encode}{If the body is a named list, how should it be encoded? Can be
  one of form (application/x-www-form-urlencoded), multipart,
  (multipart/form-data), or json (application/json).

  For "multipart", list elements can be strings or objects created by
  \code{\link{upload_file}}. For "form", elements are coerced to strings
  and escaped, use \code{I()} to prevent double-escaping.}

\item{multipart}{Deprecated. \code{TRUE} = \code{encode = "multipart"},
\code{FALSE} = {encode = "form"}.
Files can not be uploaded when \code{FALSE}.}

\item{handle}{The handle to use with this request. If not
  supplied, will be retrieved and reused from the \code{\link{handle_pool}}
  based on the scheme, hostname and port of the url. By default \pkg{httr}
  requests to the same scheme/host/port combo. This substantially reduces
  connection time, and ensures that cookies are maintained over multiple
  requests to the same host. See \code{\link{handle_pool}} for more
  details.}
}
\description{
POST file to a server.
}
\examples{
b2 <- "http://httpbin.org/post"
POST(b2, body = "A simple text string")
POST(b2, body = list(x = "A simple text string"))
POST(b2, body = list(y = upload_file(system.file("CITATION"))))
POST(b2, body = list(x = "A simple text string"), encode = "json")

# Various types of empty body:
POST(b2, body = NULL, verbose())
POST(b2, body = FALSE, verbose())
POST(b2, body = "", verbose())
}

