% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_half_life.R
\name{calc_half_life}
\alias{calc_half_life}
\title{Calculates the half-life for a one compartment model.}
\usage{
calc_half_life(
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  parameters = NULL,
  species = "Human",
  model = "3compartmentss",
  suppress.messages = TRUE,
  ...
)
}
\arguments{
\item{chem.cas}{Either the cas number or the chemical name must be specified.}

\item{chem.name}{Either the chemical name or the cas number must be specified.}

\item{dtxsid}{EPA's 'DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
the chemical must be identified by either CAS, name, or DTXSIDs}

\item{parameters}{Chemical parameters from parameterize_steadystate or
1compartment function, overrides chem.name and chem.cas.}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{model}{The model used to calculate elimination rate (defaults to "3compartmentss")}

\item{suppress.messages}{Whether or not the output message is suppressed.}

\item{...}{Additional parameters passed to parameterize function if 
parameters is NULL.}
}
\value{
\item{Half life}{Units of h.}
}
\description{
This function calculates the half life from the three compartment
steady state model where elimination is entirely due to metabolism by the
liver and glomerular filtration in the kidneys.
}
\details{
Half life is calculated by dividing the natural-log of 2 by the elimination
rate from the one compartment model.
}
\examples{
calc_half_life(chem.name="Bisphenol A")
\donttest{
calc_half_life(chem.name="Bisphenol A",species="Rat")

calc_half_life(chem.cas="80-05-7")

# Volatiles are outside the domain of default model:
try(calc_half_life(
     chem.name="toluene"))

# We can turn off physchem checking:
calc_half_life(
     chem.name="toluene",
     physchem.exclude=FALSE)

# Or use an appropriate model for volatiles:
calc_half_life(
     chem.name="toluene",
     model="sumclearances")

# PFAS are outside the domain:
try(calc_half_life(
     dtxsid="DTXSID8031865",
     model="sumclearances"))

# Can turn off chemical class checking:
calc_half_life(
  dtxsid="DTXSID8031865",
  model="sumclearances",
  class.exclude=FALSE,
  suppress.messages=TRUE)

# For a metabolized compound, non-restrictive clearance should be faster:
h1 <- calc_half_life(
  chem.name="toluene",
  model="sumclearances",
  suppress.messages=TRUE)
h2 <- calc_half_life(
  chem.name="toluene",
  model="sumclearances",
  restrictive.clearance=FALSE,
  suppress.messages=TRUE)
# Check that h2 < h1:
if (!(h2 < h1)) stop("h2 not less than h1")

# Change species: 
calc_half_life(
  dtxsid="DTXSID8031865",
  species="rat",
  model="sumclearances",
  default.to.human=TRUE,
  class.exclude=FALSE,
  physchem.exclude=FALSE,
  suppress.messages=TRUE)
}

}
\seealso{
\code{\link{calc_elimination_rate}}
}
\author{
Sarah E. Davidson
}
\keyword{1compartment}
\keyword{Parameter}
