% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ionization_functions.R
\name{calc_dow}
\alias{calc_dow}
\title{Calculate the distribution coefficient}
\usage{
calc_dow(
  Pow = NULL,
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  parameters = NULL,
  pH = NULL,
  pKa_Donor = NULL,
  pKa_Accept = NULL,
  fraction_charged = NULL,
  alpha = 0.001
)
}
\arguments{
\item{Pow}{Octanol:water partition coefficient (ratio of concentrations)}

\item{chem.cas}{Either the chemical name or the CAS number must be
specified.}

\item{chem.name}{Either the chemical name or the CAS number must be
specified.}

\item{dtxsid}{EPA's 'DSSTox Structure ID (https://comptox.epa.gov/dashboard)
the chemical must be identified by either CAS, name, or DTXSIDs}

\item{parameters}{Chemical parameters from a parameterize_MODEL function,
overrides chem.name and chem.cas.}

\item{pH}{pH where ionization is evaluated.}

\item{pKa_Donor}{Compound H dissociation equilibirum constant(s).
Overwrites chem.name and chem.cas.}

\item{pKa_Accept}{Compound H association equilibirum constant(s).
Overwrites chem.name and chem.cas.}

\item{fraction_charged}{Fraction of chemical charged at the given pH}

\item{alpha}{Ratio of Distribution coefficient D of totally charged species and that of the neutral form}
}
\value{
Distribution coefficient (numeric)
}
\description{
This function estimates the ratio of the equilibrium concentrations of
a compound in octanol and water, taking into account the charge of the
compound. Given the pH, we assume the neutral (uncharged) fraction of
compound partitions according to the hydrophobicity 
(\ifelse{html}{\out{P<sub>ow</sub>}}{\eqn{P_{ow}}}). We assume that
only a fraction alpha (defaults to 0.001 -- Schmitt (2008)) of the charged
compound partitions into lipid (octanol):
\ifelse{html}{\out{D<sub>ow</sub> = P<sub>ow</sub>*(F<sub>neutral</sub> + alpha*F<sub>charged</sub>)}}{\deqn{D_{ow} = P_{ow}*(F_{neutral} + \alpha*F_{charged})}}
Fractions charged are calculated
according to hydrogen ionization equilibria (pKa_Donor, pKa_Accept) using
\code{\link{calc_ionization}}.
}
\references{
\insertRef{schmitt2008general}{httk}

\insertRef{pearce2017evaluation}{httk}

\insertRef{strope2018high}{httk}
}
\seealso{
\code{\link{calc_ionization}}
}
\author{
Robert Pearce and John Wambaugh
}
\keyword{Parameter}
