% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/benchmark_httk.R
\name{benchmark_httk}
\alias{benchmark_httk}
\title{Assess the current performance of httk relative to historical benchmarks}
\usage{
benchmark_httk(
  basic.check = TRUE,
  calc_mc_css.check = TRUE,
  in_vivo_stats.check = TRUE,
  tissuepc.check = TRUE,
  suppress.messages = TRUE,
  make.plots = TRUE
)
}
\arguments{
\item{basic.check}{Whether to run the basic checks, including uM and 
mg/L units for \code{\link{calc_analytic_css}}, \code{\link{calc_mc_css}}, 
and \code{\link{solve_pbtk}} as well as 
the number of chemicals with sufficient data to run the steady_state model 
(defaults to TRUE)}

\item{calc_mc_css.check}{Whether to check the Monte Carlo sample. A 
comparison of the output of \code{\link{calc_mc_css}} to the SimCyp outputs 
reported in 
the Wetmore et al. (2012,2015) papers is performed. A comparison between the
output of \code{\link{calc_analytic_css}} (no Monte Carlo) to the median of the output of
\code{\link{calc_mc_css}} is also performed. (defaults to TRUE)}

\item{in_vivo_stats.check}{Whether to compare the outputs of 
\code{\link{calc_mc_css}}
and \code{\link{calc_tkstats}} to in vivo measurements of Css, AUC, and 
Cmax collected
by Wambaugh et al. (2018). (defaults to TRUE)}

\item{tissuepc.check}{Whether to compare the tissue-specific partition
coefficient predictions from the calibrated Schmitt (2008) model to the 
in vivo data-derived estimates compiled by Pearce et al. (2017). (defaults 
to TRUE)}

\item{suppress.messages}{Whether or not output messages are suppressed
(defaults to TRUE)}

\item{make.plots}{Whether current benchmarks should be plotted with 
historical performance (defaults to TRUE)}
}
\value{
named list, whose elements depend on the selected checks
\tabular{ll}{
  basic \tab A list with four metrics:
 N.steadystate -- Number of chemicals with sufficient data for steady-state IVIVE
    calc_analytic.units -- Ratio of mg/L to uM * 1000 / molecular weight -- should be 1
    calc_mc.units -- Ratio should be 1
    solve_pbtk.units -- Ratio should be 1 \cr

  calc_mc_css \tab A list with four metrics:
RMSLE.Wetmore -- Root mean squared log10 error (RMSLE) in predicted Css between literature values (SimCyp, Wetmore et al. 2012,2015) and \code{\link{calc_mc_css}}
N.Wetmore -- Number of chemicals in Wetmore comparison
RMSLE.noMC -- RMSLE between \code{\link{calc_analytic_css}} and \code{\link{calc_mc_css}}
    N.noMC -- Number of chemicals in noMC comparison \cr

  in_vivo_stats \tab A list with two metrics:
RMSLE.InVivoCss -- RMSLE between the predictions of \code{\link{calc_analytic_css}} and in vivo estimates of Css
N.InVivoCss -- Number of chemicals in comparison \cr                    
  
  units.plot \tab A ggplot2 figure showing units tests of various functions. 
Output is generated for mg/L and uM, and then the ratio mg/L/uM*1000/MW is
calculated. If the units are correct the ratio should be 1 (within the 
precision of the functions -- usually four significant figures). \cr

  rmsle.plot \tab A ggplot2 figure showing RMSLE tests of various functions. 
Output generated is the root mean square log10 error for parameters estimated
by the package. \cr

  count.plot \tab A ggplot2 figure showing count of chemicals of various functions. 
Output generated is a count of the chemicals available for the each of the
parameters estimated by and used for benchmarking the package. \cr
}
}
\description{
The function performs a series of "sanity checks" and predictive performance
benchmarks so that the impact of changes to the data, models, and 
implementation of the R package can be tested. Plots can be generated showing 
how the performance of the current version compares with past releases of
httk.
}
\details{
Historically some refinements made to one aspect of httk have unintentionally
impacted other aspects. Most notably errors have occasionally been introduced 
with respect to units (v1.9, v2.1.0). This benchmarking tool is intended to
reduce the chance of these errors occurring in the future.

Past performance was retroactively evaluated by manually installing previous 
versions of 
the package from \url{https://cran.r-project.org/src/contrib/Archive/httk/} and
then adding the code for \code{benchmark_httk} at the command line
interface. 

The basic tests are important -- if the output units for key functions are wrong, not
much can be right. Past unit errors were linked to an incorrect unit 
conversions made within an individual function. Since the usage of 
\code{\link{convert_units}} became standard throughout httk,
unit problems are hopefully less likely.

There are two Monte Carlo tests. One compares \code{\link{calc_mc_css}} 95th percentile
steady-state plasma concentrations for a 1 mg/kg/day exposure
against the Css values calculated by SimCyp and reported in Wetmore et al.
(2012,2015). These have gradually diverged as the assumptions for httk have
shifted to better describe non-pharmaceutical, commercial chemicals.

The in vivo tests are in some ways the most important, as they establish the
overall predictability for httk for Cmax, AUC, and Css. The in vivo 
statistics are currently based on comparisons to the in vivo
data compiled by Wambaugh et al. (2018). We see that when the tissue
partition coefficient calibrations were introduced in v1.6 that the
overall predictability for in vivo endpoints was reduced (increased RMSLE).
If this phenomena continues as new in vivo evaluation data become available,
we may need to revisit whether evaluation against experimentally-derived 
partition coefficients can actually be used for calibration, or just merely
for establishing confidence intervals.

The partition coefficient tests provide an important check of the httk
implementation of the Schmitt (2008) model for tissue:plasma equilibrium 
distribution. These predictions heavily rely on accurate description of 
tissue composition and the ability to predict the ionization state of the
compounds being modeled.
}
\references{
\insertRef{DavidsonFritzUnpublishedModelAdding}{httk}
}
\author{
John Wambaugh
}
