% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameterize_steadystate.R
\name{parameterize_steadystate}
\alias{parameterize_steadystate}
\title{Parameterize_SteadyState}
\usage{
parameterize_steadystate(
  chem.cas = NULL,
  chem.name = NULL,
  dtxsid = NULL,
  species = "Human",
  clint.pvalue.threshold = 0.05,
  default.to.human = F,
  human.clint.fup = F,
  adjusted.Funbound.plasma = T,
  restrictive.clearance = T,
  fup.lod.default = 0.005,
  suppress.messages = F,
  minimum.Funbound.plasma = 1e-04
)
}
\arguments{
\item{chem.cas}{Chemical Abstract Services Registry Number (CAS-RN) -- the 
chemical must be identified by either CAS, name, or DTXISD}

\item{chem.name}{Chemical name (spaces and capitalization ignored) --  the 
chemical must be identified by either CAS, name, or DTXISD}

\item{dtxsid}{EPA's DSSTox Structure ID (\url{https://comptox.epa.gov/dashboard})
-- the chemical must be identified by either CAS, name, or DTXSIDs}

\item{species}{Species desired (either "Rat", "Rabbit", "Dog", "Mouse", or
default "Human").}

\item{clint.pvalue.threshold}{Hepatic clearances with clearance assays
having p-values greater than the threshold are set to zero.}

\item{default.to.human}{Substitutes missing rat values with human values if
true.}

\item{human.clint.fup}{Uses human hepatic intrinsic clearance and fraction
of unbound plasma in calculation of partition coefficients for rats if true.}

\item{adjusted.Funbound.plasma}{Returns adjusted Funbound.plasma when set to
TRUE.}

\item{restrictive.clearance}{In calculating hepatic.bioavailability, protein
binding is not taken into account (set to 1) in liver clearance if FALSE.}

\item{fup.lod.default}{Default value used for fraction of unbound plasma for
chemicals where measured value was below the limit of detection. Default
value is 0.0005.}

\item{suppress.messages}{Whether or not the output message is suppressed.}

\item{minimum.Funbound.plasma}{Monte Carlo draws less than this value are set 
equal to this value (default is 0.0001 -- half the lowest measured Fup in our
dataset).}
}
\value{
\item{Clint}{Hepatic Intrinsic Clearance, uL/min/10^6 cells.}
\item{Fgutabs}{Fraction of the oral dose absorbed, i.e. the fraction of the
dose that enters the gutlumen.} 
\item{Funbound.plasma}{Fraction of plasma that is not bound.} 
\item{Qtotal.liverc}{Flow rate of blood exiting the liver, L/h/kg BW^3/4.} 
\item{Qgfrc}{Glomerular Filtration Rate, L/h/kg
BW^3/4, volume of fluid filtered from kidney and excreted.} 
\item{BW}{Body Weight, kg} 
\item{MW}{Molecular Weight, g/mol}
\item{million.cells.per.gliver}{Millions cells per gram of liver tissue.}
\item{Vliverc}{Volume of the liver per kg body weight, L/kg BW.}
\item{liver.density}{Liver tissue density, kg/L.}
\item{Fhep.assay.correction}{The fraction of chemical unbound in hepatocyte
assay using the method of Kilford et al. (2008)}
\item{hepatic.bioavailability}{Fraction of dose remaining after first pass
clearance, calculated from the corrected well-stirred model.}
}
\description{
This function initializes the parameters needed in the functions
calc_mc_css, calc_mc_oral_equiv, and calc_analytic_css for the three
compartment steady state model ('3compartmentss').
}
\examples{

 parameters <- parameterize_steadystate(chem.name='Bisphenol-A',species='Rat')
 parameters <- parameterize_steadystate(chem.cas='80-05-7')

}
\references{
Pearce, Robert G., et al. "Httk: R package for high-throughput 
toxicokinetics." Journal of statistical software 79.4 (2017): 1.

Kilford, P. J., Gertz, M., Houston, J. B. and Galetin, A.
(2008). Hepatocellular binding of drugs: correction for unbound fraction in
hepatocyte incubations using microsomal binding or drug lipophilicity data.
Drug Metabolism and Disposition 36(7), 1194-7, 10.1124/dmd.108.020834.
}
\author{
John Wambaugh
}
\keyword{3compss}
\keyword{Parameter}
