% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tissue_masses_flows.R
\name{tissue_masses_flows}
\alias{tissue_masses_flows}
\title{Given a data.table describing a virtual population by the NHANES quantities, 
generates HTTK physiological parameters for each individual.}
\usage{
tissue_masses_flows(tmf_dt)
}
\arguments{
\item{tmf_dt}{A data.table generated by
\code{gen_age_height_weight()}, containing variables \code{gender},
\code{reth}, \code{age_months}, \code{age_years}, \code{weight}, and
\code{height}.}
}
\value{
The same data.table, with aditional variables describing tissue masses
 and flows.
}
\description{
Given a data.table describing a virtual population by the NHANES quantities, 
generates HTTK physiological parameters for each individual.
}
\references{
Barter, Zoe E., et al. "Scaling factors for the extrapolation of in vivo 
metabolic drug clearance from in vitro data: reaching a consensus on values 
of human micro-somal protein and hepatocellularity per gram of liver." Current 
Drug Metabolism 8.1 (2007): 33-45.

Birnbaum, L., et al. "Physiological parameter values for PBPK models." 
International Life Sciences Institute, Risk Science Institute, Washington, 
DC (1994).

Geigy Pharmaceuticals, "Scientific Tables", 7th Edition, 
John Wiley and Sons (1970)

McNally, Kevin, et al. "PopGen: a virtual human population generator." 
Toxicology 315 (2014): 70-85.

Ring, Caroline L., et al. "Identifying populations sensitive to 
environmental chemicals by simulating toxicokinetic variability." Environment 
International 106 (2017): 105-118
}
\author{
Caroline Ring
}
\keyword{httk-pop}
