% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/postestimation.R
\name{posterior_linpred.hsstan}
\alias{posterior_linpred.hsstan}
\alias{posterior_linpred}
\title{Posterior distribution of the linear predictor}
\usage{
\method{posterior_linpred}{hsstan}(object, transform = FALSE,
  newdata = NULL, ...)
}
\arguments{
\item{object}{An object of class \code{hsstan}.}

\item{transform}{Whether the linear predictor should be transformed using
the inverse-link function (\code{FALSE} by default).}

\item{newdata}{Optional data frame containing the variables to use to
predict. If \code{NULL} (default), the model matrix is used. If
specified, its continuous variables should be standardized, since
the model coefficients are learnt on standardized data.}

\item{...}{Currently ignored.}
}
\value{
A matrix of size \code{S} by \code{N}, where \code{S} is the number of draws from the
posterior distribution of the (transformed) linear predictor, and \code{N} is
the number of data points.
}
\description{
Extract the posterior draws of the linear predictor, possibly transformed
by the inverse-link function.
}
\examples{
\dontshow{utils::example("hsstan", echo=FALSE)}
# continued from ?hsstan
posterior_linpred(hs.biom)

}
