% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/error_regimes.R
\name{error_regimes}
\alias{error_regimes}
\alias{coef.error_regimes}
\alias{vcov.error_regimes}
\alias{print.error_regimes}
\alias{summary.error_regimes}
\alias{print.summary.error_regimes}
\title{Estimation of spatial regimes models}
\usage{
error_regimes(
  formula,
  data,
  listw,
  rgv,
  weps_rg = FALSE,
  initial.value = NULL,
  het,
  verbose = FALSE,
  control,
  cl
)

\method{coef}{error_regimes}(object, ...)

\method{vcov}{error_regimes}(object, ...)

\method{print}{error_regimes}(x, digits = max(3, getOption("digits") - 3), ...)

\method{summary}{error_regimes}(object, ...)

\method{print}{summary.error_regimes}(x, digits = max(5, getOption("digits") - 3), ...)
}
\arguments{
\item{formula}{a symbolic description of the model of the form \code{y ~ x_f | x_v | wx | h_f | h_v | wh} where \code{y} is the dependent variable, \code{x_f} are the regressors that do not vary by regimes,  \code{x_v} are the regressors that vary by regimes, \code{wx} are the spatially lagged regressors, \code{h_f} are the instruments that do not vary by regimes,  \code{h_v} are the instruments that vary by regimes, \code{wh} are the spatially lagged instruments.}

\item{data}{the data of class \code{data.frame}.}

\item{listw}{a spatial weighting matrix of class \code{listw}, \code{matrix} or \code{Matrix}}

\item{rgv}{an object of class \code{formula} to identify the regime variables}

\item{weps_rg}{default \code{weps_rg = FALSE}, the errors do not vary by regime (see details)}

\item{initial.value}{initial value for the spatial error parameter}

\item{het}{heteroskedastic variance-covariance matrix}

\item{verbose}{print a trace of the optimization}

\item{control}{argument for optimization}

\item{cl}{record calls}

\item{object}{an object of class error_regimes}

\item{...}{additional arguments}

\item{x}{an object of class error_regimes}

\item{digits}{number of digits}
}
\value{
An object of class \code{"error_regimes"}. A \code{list} of five elements. The first element of the \code{list} contains the estimation results. The other elements are needed for printing.
}
\description{
Estimation of spatial regimes models
}
\examples{
data("natreg")
data("ws_6")
form <-  HR90  ~ 0 | MA90 + PS90 +
RD90 + UE90 | 0 | 0 | MA90 + PS90 +
RD90 + FH90 + FP89 + GI89 | 0

form1 <-  HR90  ~ MA90 -1 |  PS90 +
RD90 + UE90 | 0 | MA90 -1 |  PS90 +
RD90 + FH90 + FP89 + GI89 | 0

split  <- ~ REGIONS

###############################
# spatial error regimes model #
###############################
mod <- spregimes(formula = form, data = natreg,
rgv = split, listw = ws_6, model = "error", het = TRUE)
summary(mod)
mod1 <- spregimes(formula = form, data = natreg,
rgv = split, listw = ws_6, model = "error",
weps_rg = TRUE, het = TRUE)
summary(mod1)
mod2 <- spregimes(formula = form1, data = natreg,
rgv = split, listw = ws_6, model = "error", het = TRUE)
summary(mod2)
}
