% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hrq_glasso_cv.R
\name{cv.hrq_glasso}
\alias{cv.hrq_glasso}
\title{Cross-validation for quantile regression with group lasso}
\usage{
cv.hrq_glasso(
  x,
  y,
  group.index,
  tau = 0.5,
  k = 5,
  loss = "check",
  method = "quantile",
  folds = NULL,
  ...
)
}
\arguments{
\item{x}{Design matrix}

\item{y}{Response variable}

\item{group.index}{A vector of group index, e.g., (1,1,1,2,2,2,3,3)}

\item{tau}{Percentage}

\item{k}{Number of folders.}

\item{loss}{The loss function used for computing the cross-validation error. Supported losses include squared error (\code{se}), absolute error (\code{ae}), quantile check loss (\code{check}) and huber loss (\code{he}).}

\item{method}{Choice for mean or quantile regression. Default is \code{quantile}.}

\item{folds}{A vector of folder index for all observations. The procedure random splits if this argument is not specified.}

\item{...}{Other inputs of function \code{hrq_glasso()}.}
}
\value{
The full solution path is returned. It also returns the vector of CV score 
as well as the optimal values in terms of min and 1se. Corresponding lambda values are also returned. 
\item{beta}{The estimated coefficients for all lambdas, stored in sparse matrix format, where each column corresponds to a lambda.}
\item{lambda}{The sequence of lambdas.}
\item{lambda.min}{The optimal lambda that minimizes the CV error}
\item{lambda.1se}{The largest lambda such that CV error is within 1 standard error of the minimum CV error.}
\item{cv.all}{The vector of all values of CV error for all lambdas.}
\item{cv.min}{The value of CV error corresponding to \code{lambda.min}.}
\item{cv.1se}{The value of CV error corresponding to \code{lambda.1se}.}
\item{folds}{The vector of indices for k folds split.}
\item{cvup}{CV error + 1 standard error}
\item{cvlo}{CV error + 1 standard error}
\item{n.grp}{The number of selected groups for each lambda.}
}
\description{
K fold cross-validation is conducted. Four types of loss (squared error (\code{se}), absolute error (\code{ae})
quantile check loss (\code{check}) and huber loss (\code{he})) 
can be specified as the CV criterion.
}
\examples{
n<- 100
p<- 10
x0<- matrix(rnorm(n*p),n,p)
X<- cbind(x0, x0^2, x0^3)[,order(rep(1:p,3))]
y<- -2+X[,1]+0.5*X[,2]-X[,3]-0.5*X[,7]+X[,8]-0.2*X[,9]+rt(n,2)
group<- rep(1:p, each=3)
fitcv<- cv.hrq_glasso(x=X, y=y, group.index=group, method="quantile")
plot(fitcv)
}
