% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcVolatility.R
\name{calcVolatility}
\alias{calcVolatility}
\title{Calculate index volatility}
\usage{
calcVolatility(index, window = 3, in_place = FALSE,
  in_place_name = "volatility", smooth = FALSE, ...)
}
\arguments{
\item{index}{An object of class `hpiindex`}

\item{window}{default = 3; Rolling periods over which to calculate the volatility}

\item{in_place}{default = FALSE; Adds volatility metric to the `hpiindex` object
(may be within an `hpi` object)}

\item{in_place_name}{default = 'vol'; Name of volatility object in `hpiindex` object}

\item{smooth}{default = FALSE; Calculate on the smoothed index?}

\item{...}{Additional arguments}
}
\value{
an `indexvolatility` (S3) object, the 'index' slot of which is a `ts` object
\describe{
  \item{roll}{ volatility at each rolling point}
  \item{mean}{overall mean volatility}
  \item{median}{overall median volatility}
}
}
\description{
Create estimate of index volatility given a window
}
\section{Further Details}{

You may also provide an `hpi` object to this function.  If you do, it will
extract the `hpiindex` object from the `index` slot in the `hpi` class object.
}

\examples{

 # Load Data
 data(ex_sales)

 # Create index with raw transaction data
 rt_index <- rtIndex(trans_df = ex_sales,
                     periodicity = 'monthly',
                     min_date = '2010-06-01',
                     max_date = '2015-11-30',
                     adj_type = 'clip',
                     date = 'sale_date',
                     price = 'sale_price',
                     trans_id = 'sale_id',
                     prop_id = 'pinx',
                     estimator = 'robust',
                     log_dep = TRUE,
                     trim_model = TRUE,
                     max_period = 48,
                     smooth = FALSE)

 # Calculate Volatility
 index_vol <- calcVolatility(index = rt_index,
                             window = 3)

}
