% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hms.R
\name{hms}
\alias{hms}
\title{Maximization (or minimization) of a fitness function using Hierarchic Memetic Strategy.}
\usage{
hms(
  tree_height = 3,
  minimize = FALSE,
  fitness,
  lower,
  upper,
  sigma = default_sigma(lower, upper, tree_height),
  population_sizes = default_population_sizes(tree_height),
  run_metaepoch = default_ga_metaepoch(tree_height),
  gsc = gsc_default,
  lsc = lsc_default,
  sc = sc_max_metric(euclidean_distance, sprouting_default_euclidean_distances(sigma)),
  create_population = default_create_population(sigma),
  suggestions = NULL,
  with_gradient_method = FALSE,
  gradient_method_args = default_gradient_method_args,
  run_gradient_method,
  monitor_level = "basic",
  parallel = FALSE
)
}
\arguments{
\item{tree_height}{numeric - default value: 5. It determines the maximum tree height
which will usually be reached unless a very strict local stopping condition, global
stopping condition or sprouting condition is used.}

\item{minimize}{logical - \code{TRUE} when fitness shall be minimized.}

\item{fitness}{fitness function, that returns a numerical value, to be optimized by the strategy.}

\item{lower}{numeric - lower bound of the domain, a vector of length equal
to the decision variables.}

\item{upper}{numeric - upper bound of the domain, a vector of length equal
to the decision variables.}

\item{sigma}{numeric - Vector of standard deviations for each tree level used to create
a population of a sprouted deme.}

\item{population_sizes}{numeric - Sizes of deme populations on each tree level.}

\item{run_metaepoch}{A function that takes 5 parameters: fitness, suggestions, lower,
upper, tree_level, runs a metaepoch on the given deme population and returns list with
3 named fields: solution, population, value.}

\item{gsc}{global stopping condition function taking a list of MetaepochSnapshot
objects and returning a logical value; it is evaluated after every metaepoch and
determines whether whole computation should be stopped. See \code{\link{gsc_metaepochs_count}} for more details.}

\item{lsc}{local stopping condition - function taking a deme and a list of MetaepochSmapshot
objects representing previous metaepochs; it is run on every deme after it has run a metaepoch
and determines whether that deme will remain active. See \code{\link{lsc_max_fitness_evaluations}} for more details.}

\item{sc}{sprouting condition - function taking 3 arguments: an individual, a tree level
and a list of Deme objects; it determines whether the given individual can sprout a new deme
on the given level. See \code{\link{sc_max_metric}} for more details.}

\item{create_population}{function taking 6 parameters: mean, lower, upper, population_size,
tree_level, sigma that returns a population for a Deme object to be created on the given
tree level.}

\item{suggestions}{matrix of individuals for the initial population of the root}

\item{with_gradient_method}{logical determining whether a gradient method should be run
for all leaves at the end of the computation to refine their best solutions.}

\item{gradient_method_args}{list of parameters that are passed to the gradient method}

\item{run_gradient_method}{function - returns list with named fields: solution, population, value}

\item{monitor_level}{string - one of: 'none', 'basic', 'basic_tree', 'verbose_tree'.}

\item{parallel}{logical - \code{TRUE} when run_metaepoch runs in parallel.}
}
\value{
Returns an object of class hms.
}
\description{
Maximization (or minimization) of a fitness function using Hierarchic Memetic Strategy.
}
\examples{
f <- function(x) x
result <- hms(fitness = f, lower = -5, upper = 5)
}
