% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmi_smallfunctions.R
\name{plot.interval}
\alias{plot.interval}
\title{Plotting interval variables}
\usage{
\method{plot}{interval}(x = NULL, y = NULL, data = NULL,
  col = "black", xlab = NULL, ylab = NULL, xlim = NULL,
  ylim = NULL, sort = NULL, ...)
}
\arguments{
\item{x}{In its most save way, \code{x} is an object from class \code{interval}
and jointly used with a second \code{interval} object \code{y}. If no \code{y} is given,
the values of \code{x} are just plotted in order of appearance
(cf. \code{plot(iris$Sepal.Length)}).
\code{x} can also be a \code{formula} with two variables found in \code{data}.}

\item{y}{If used jointly with \code{x}, it has to be a numeric vector or an \code{interval} object.}

\item{data}{If \code{x} is a \code{fomula}, it has to be a data.frame or matrix with column names
fitting to the two variables named in the formula.}

\item{col}{The color of the rectangles.}

\item{xlab}{A title for the x axis: see \code{title}.}

\item{ylab}{A title for the y axis: see \code{title}.}

\item{xlim}{Numeric vectors of length 2, giving the x coordinate ranges.}

\item{ylim}{Numeric vectors of length 2, giving the y coordinate ranges.}

\item{sort}{A character specifying how the values should be sorted if only one variable is to be plotted.
By default they are sorted according to their position in the data set.
\code{sort = "lowerbound_increasing"} sorts the data primarily by their lower bound, and secondarily
(this means for equal lower bounds) by their upper bounds. Both in increasing order.
For \code{sort = "lowerbound_decreasing"}, both happens in decreasing order.
\code{sort = "mostprecise_increasing"} sorts the data by their length of the interval they represent,
and within equal lengths by the lower bound. Both in increasing order.
For \code{sort = "mostprecise_decreasing"}, both happens in decreasing order.}

\item{...}{graphical parameters such as \code{main}.}
}
\description{
Function to plot interval variables by rectangles. The bounds of the rectangles are given by the
lower and upper bounds of the interval variables. To avoid precise observations to have a line-width
of 0, small values are added to the upper and lower bounds what guarantees the rectangles (or lines or points)
to be easily visible in the plot.
}
