% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hmi_smallfunctions_2017-11-14.R
\name{negloglik2}
\alias{negloglik2}
\title{calculate the likelihood contribution of the data}
\usage{
negloglik2(para, X, y_in_negloglik, lower = NA, upper = NA, my_p,
  mean_y_precise, sd_y_precise)
}
\arguments{
\item{para}{This is the vector \eqn{Psi} of parameters
(see p. 62 in Drechsler, Kiesl & Speidel, 2015).
With respect to them, the value returned by negloglik2 shall be
maximized.\cr
The starting values are c(kstart, betastart2, gammastart, sigmastart2)
(the 6 thresholds (or "cutting points") for the latent variable behind the rounding degree,
the regression parameters explaining the logged income,
the regression parameters explaining the rounding degree
and the variance parameter).}

\item{X}{the data.frame of covariates.}

\item{y_in_negloglik}{the target variable (a vector).}

\item{lower}{the lower bound of an interval variable.}

\item{upper}{the upper bound of an interval variable.}

\item{my_p}{This vector is the indicator of the (highest possible) rounding degree for an observation.
This parameter comes directly from the data.}

\item{mean_y_precise}{the scalar with the value of the mean of the target variable.}

\item{sd_y_precise}{the scalar with the value equal to the standard deviation of the target variable.}
}
\value{
An integer equal to the (sum of the) negative log-likelihood contributions (of the observations)
}
\description{
This function based on Drechsler, Kiesl & Speidel (2015)
is needed in the imputation routine for rounded income.
It calculates the likelihood contribution of the data
(regardless whether they are observed precisely or presumably rounded).
}
\references{
Joerg Drechsler, Hans Kiesl, Matthias Speidel (2015):
"MI Double Feature: Multiple Imputation to Address Nonresponse and Rounding Errors in Income Questions",
Austrian Journal of Statistics, Vol. 44, No. 2, \url{http://dx.doi.org/10.17713/ajs.v44i2.77}
}
