% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dataHandling.R
\name{businessTimeAggregation}
\alias{businessTimeAggregation}
\title{Business time aggregation}
\usage{
businessTimeAggregation(
  pData,
  measure = "volume",
  obs = 390,
  bandwidth = 0.075,
  tz = NULL,
  ...
)
}
\arguments{
\item{pData}{\code{xts} or \code{data.table} containing data to aggregate.}

\item{measure}{character denoting which measure to use. Valid options are \code{"intensity"}, \code{"vol"}, and \code{"volume"}, 
denoting the trade intensity process of Oomen (2005), volatility, and volume, respectively. Default is \code{"volume"}.}

\item{obs}{integer valued numeric of length 1 denoting how many observations is wanted after the aggregation procedure.}

\item{bandwidth}{numeric of length one, denoting which bandwidth parameter to use in the trade intensity process estimation of Oomen (2005).}

\item{tz}{fallback time zone used in case we we are unable to identify the timezone of the data, by default: \code{tz = NULL}. We attempt to extract the timezone from the DT column (or index) of the data, which may fail. 
In case of failure we use \code{tz} if specified, and if it is not specified, we use \code{"UTC"}.}

\item{...}{extra arguments passed on to \code{\link{spotVol}} when measure is \code{"vol"}.}
}
\value{
A list containing \code{"pData"} which is the aggregated data and a list containing the intensity process, split up day by day.
}
\description{
Time series aggregation based on `business time` statistics. Instead of equidistant sampling based on time during a trading day, business time sampling creates measures and samples equidistantly using these instead.
For example when sampling based on volume, business time aggregation will result in a time series that has an equal amount of volume between each observation (if possible).
}
\examples{
pData <- sampleTData[,list(DT, PRICE, SIZE)]
# Aggregate based on the trade intensity measure. Getting 390 observations.
agged <- businessTimeAggregation(pData, measure = "intensity", obs = 390, bandwidth = 0.075)
# Plot the trade intensity measure
plot.ts(agged$intensityProcess$`2018-01-02`)
rCov(agged$pData[, list(DT, PRICE)], makeReturns = TRUE)
rCov(pData[,list(DT, PRICE)], makeReturns = TRUE, alignBy = "minutes", alignPeriod = 1)

# Aggregate based on the volume measure. Getting 78 observations.
agged <- businessTimeAggregation(pData, measure = "volume", obs = 78)
rCov(agged$pData[,list(DT, PRICE)], makeReturns = TRUE)
rCov(pData[,list(DT, PRICE)], makeReturns = TRUE, alignBy = "minutes", alignPeriod = 5)

}
\references{
Dong, Y., and Tse, Y. K. (2017). Business time sampling scheme with applications to testing semi-martingale hypothesis and estimating integrated volatility. \emph{Econometrics}, 5, 51.

Oomen, R. C. A. (2006). Properties of realized variance under alternative sampling schemes. \emph{Journal of Business & Economic Statistics}, 24, 219-237
}
\author{
Emil Sjoerup.
}
